/*
 * Decompiled with CFR 0.152.
 */
package eis.iilang;

import eis.iilang.IILElement;
import eis.iilang.Parameter;
import eis.iilang.Percept;
import java.util.LinkedList;

public abstract class DataContainer
extends IILElement {
    private static final long serialVersionUID = 1139628940335051005L;
    protected String name = null;
    protected LinkedList<Parameter> params = new LinkedList();
    protected long timeStamp = System.currentTimeMillis();
    protected String source = null;

    protected DataContainer() {
    }

    public DataContainer(String name, Parameter ... parameters) {
        this.setName(name);
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            this.params.add(p);
            ++n2;
        }
    }

    public DataContainer(String name, LinkedList<Parameter> parameters) {
        this.setName(name);
        this.params = parameters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        assert (Character.isLowerCase(name.charAt(0))) : String.valueOf(name) + " should start with a lowercase letter";
        this.name = name;
    }

    public LinkedList<Parameter> getParameters() {
        return this.params;
    }

    public LinkedList<Parameter> getClonedParameters() {
        LinkedList<Parameter> ret = new LinkedList<Parameter>();
        for (Parameter p : this.params) {
            ret.add((Parameter)p.clone());
        }
        return ret;
    }

    public void setParameters(LinkedList<Parameter> params) {
        this.params = params;
    }

    public void addParameter(Parameter p) {
        this.params.add(p);
    }

    public static Percept toPercept(DataContainer container) {
        Parameter[] parameters = new Parameter[container.params.size()];
        int a = 0;
        while (a < parameters.length) {
            parameters[a] = container.params.get(a);
            ++a;
        }
        return new Percept(container.getName(), parameters);
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataContainer)) {
            return false;
        }
        DataContainer dc = (DataContainer)obj;
        if (!dc.name.equals(this.name)) {
            return false;
        }
        if (dc.params.size() != this.params.size()) {
            return false;
        }
        int a = 0;
        while (a < this.params.size()) {
            if (!dc.params.get(a).equals(this.params.get(a))) {
                return false;
            }
            ++a;
        }
        return true;
    }
}

