/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.easymock.IAnswer;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
implements IAnswer<Object>,
Serializable {
    private static final long serialVersionUID = 5476251941213917681L;
    private final IAnswer<?> value;
    private final boolean shouldFillInStackTrace;

    private Result(IAnswer<?> value, boolean shouldFillInStackTrace) {
        this.value = value;
        this.shouldFillInStackTrace = shouldFillInStackTrace;
    }

    public static Result createThrowResult(Throwable throwable) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ThrowingAnswer
        implements IAnswer<Object>,
        Serializable {
            private static final long serialVersionUID = -332797751209289222L;
            final /* synthetic */ Throwable val$throwable;

            ThrowingAnswer(Throwable throwable) {
                this.val$throwable = throwable;
            }

            @Override
            public Object answer() throws Throwable {
                throw this.val$throwable;
            }

            public String toString() {
                return "Answer throwing " + this.val$throwable;
            }
        }
        return new Result(new ThrowingAnswer(throwable), true);
    }

    public static Result createReturnResult(Object value) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ReturningAnswer
        implements IAnswer<Object>,
        Serializable {
            private static final long serialVersionUID = 6973893913593916866L;
            final /* synthetic */ Object val$value;

            ReturningAnswer(Object object) {
                this.val$value = object;
            }

            @Override
            public Object answer() throws Throwable {
                return this.val$value;
            }

            public String toString() {
                return "Answer returning " + this.val$value;
            }
        }
        return new Result(new ReturningAnswer(value), true);
    }

    public static Result createDelegatingResult(Object value) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DelegatingAnswer
        implements IAnswer<Object>,
        Serializable {
            private static final long serialVersionUID = -5699326678580460103L;
            final /* synthetic */ Object val$value;

            DelegatingAnswer(Object object) {
                this.val$value = object;
            }

            @Override
            public Object answer() throws Throwable {
                Invocation invocation = LastControl.getCurrentInvocation();
                try {
                    return invocation.getMethod().invoke(this.val$value, invocation.getArguments());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Delegation to object [" + String.valueOf(this.val$value) + "] is not implementing the mocked method [" + invocation.getMethod() + "]", e);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }

            public String toString() {
                return "Delegated to " + this.val$value;
            }
        }
        return new Result(new DelegatingAnswer(value), false);
    }

    public static Result createAnswerResult(IAnswer<?> answer) {
        return new Result(answer, false);
    }

    @Override
    public Object answer() throws Throwable {
        return this.value.answer();
    }

    public boolean shouldFillInStackTrace() {
        return this.shouldFillInStackTrace;
    }

    public String toString() {
        return this.value.toString();
    }
}

