/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.egl;

import javax.media.nativewindow.DefaultGraphicsDevice;
import javax.media.nativewindow.NativeWindowException;

public class EGLGraphicsDevice
extends DefaultGraphicsDevice
implements Cloneable {
    final long nativeDisplayID;
    final EGLDisplayLifecycleCallback eglLifecycleCallback;

    public EGLGraphicsDevice(String string, int n) {
        super("EGL", string, n);
        this.nativeDisplayID = 0L;
        this.eglLifecycleCallback = null;
    }

    public EGLGraphicsDevice(long l, long l2, String string, int n, EGLDisplayLifecycleCallback eGLDisplayLifecycleCallback) {
        super("EGL", string, n, l2);
        this.nativeDisplayID = l;
        this.eglLifecycleCallback = eGLDisplayLifecycleCallback;
    }

    public long getNativeDisplayID() {
        return this.nativeDisplayID;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean open() {
        if (null != this.eglLifecycleCallback && 0L == this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - EGLGraphicsDevice.open(): " + this);
            }
            this.handle = this.eglLifecycleCallback.eglGetAndInitDisplay(this.nativeDisplayID);
            if (0L == this.handle) {
                throw new NativeWindowException("EGLGraphicsDevice.open() failed: " + this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean close() {
        if (null != this.eglLifecycleCallback && 0L != this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - EGLGraphicsDevice.close(): " + this);
            }
            this.eglLifecycleCallback.eglTerminate(this.handle);
        }
        return super.close();
    }

    @Override
    public String toString() {
        return "EGLGraphicsDevice[type EGL, connection " + this.getConnection() + ", unitID " + this.getUnitID() + ", handle 0x" + Long.toHexString(this.getHandle()) + ", nativeDisplayID 0x" + Long.toHexString(this.nativeDisplayID) + "]";
    }

    public static interface EGLDisplayLifecycleCallback {
        public long eglGetAndInitDisplay(long var1);

        public void eglTerminate(long var1);
    }
}

