/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.math;

import jogamp.graph.math.MathFloat;

public class Quaternion {
    protected float x;
    protected float y;
    protected float z;
    protected float w;

    public Quaternion() {
    }

    public Quaternion(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public Quaternion(float[] fArray, float[] fArray2) {
        float f = MathFloat.acos(this.dot(fArray, fArray2));
        float[] fArray3 = this.cross(fArray, fArray2);
        fArray3 = this.normalizeVec(fArray3);
        this.x = MathFloat.sin(f / 2.0f) * fArray3[0];
        this.y = MathFloat.sin(f / 2.0f) * fArray3[1];
        this.z = MathFloat.sin(f / 2.0f) * fArray3[2];
        this.w = MathFloat.cos(f / 2.0f);
        this.normalize();
    }

    public float[] toAxis() {
        float[] fArray = new float[4];
        float f = MathFloat.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        fArray[0] = MathFloat.acos(this.w) * 2.0f;
        fArray[1] = this.x / f;
        fArray[2] = this.y / f;
        fArray[3] = this.z / f;
        return fArray;
    }

    private float[] normalizeVec(float[] fArray) {
        float[] fArray2 = new float[3];
        float f = MathFloat.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        if (f > 0.0f) {
            fArray2[0] = fArray[0] / f;
            fArray2[1] = fArray[1] / f;
            fArray2[2] = fArray[2] / f;
        }
        return fArray2;
    }

    private float dot(float[] fArray, float[] fArray2) {
        return fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2];
    }

    private float[] cross(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{fArray2[2] * fArray[1] - fArray2[1] * fArray[2], fArray2[0] * fArray[2] - fArray2[2] * fArray[0], fArray2[1] * fArray[0] - fArray2[0] * fArray[1]};
        return fArray3;
    }

    public float getW() {
        return this.w;
    }

    public void setW(float f) {
        this.w = f;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float f) {
        this.z = f;
    }

    public void add(Quaternion quaternion) {
        this.x += quaternion.x;
        this.y += quaternion.y;
        this.z += quaternion.z;
    }

    public void subtract(Quaternion quaternion) {
        this.x -= quaternion.x;
        this.y -= quaternion.y;
        this.z -= quaternion.z;
    }

    public void divide(float f) {
        this.x /= f;
        this.y /= f;
        this.z /= f;
    }

    public void mult(Quaternion quaternion) {
        float f = this.w * quaternion.w - (this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z);
        float f2 = this.w * quaternion.z + quaternion.w * this.z + this.y * quaternion.z - this.z * quaternion.y;
        float f3 = this.w * quaternion.x + quaternion.w * this.x + this.z * quaternion.x - this.x * quaternion.z;
        float f4 = this.w * quaternion.y + quaternion.w * this.y + this.x * quaternion.y - this.y * quaternion.x;
        this.w = f;
        this.x = f2;
        this.y = f3;
        this.z = f4;
    }

    public void mult(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    public void normalize() {
        float f = MathFloat.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
        if (f == 0.0f) {
            this.w = 1.0f;
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
        } else {
            float f2 = 1.0f / f;
            this.w *= f2;
            this.x *= f2;
            this.y *= f2;
            this.z *= f2;
        }
    }

    public void inverse() {
        float f = this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
        float f2 = 1.0f / f;
        this.w *= f2;
        this.x = -1.0f * this.x * f2;
        this.y = -1.0f * this.y * f2;
        this.z = -1.0f * this.z * f2;
    }

    public float[] toMatrix() {
        float[] fArray = new float[]{1.0f - 2.0f * this.y * this.y - 2.0f * this.z * this.z, 2.0f * this.x * this.y + 2.0f * this.w * this.z, 2.0f * this.x * this.z - 2.0f * this.w * this.y, 0.0f, 2.0f * this.x * this.y - 2.0f * this.w * this.z, 1.0f - 2.0f * this.x * this.x - 2.0f * this.z * this.z, 2.0f * this.y * this.z + 2.0f * this.w * this.x, 0.0f, 2.0f * this.x * this.z + 2.0f * this.w * this.y, 2.0f * this.y * this.z - 2.0f * this.w * this.x, 1.0f - 2.0f * this.x * this.x - 2.0f * this.y * this.y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return fArray;
    }

    public void slerp(Quaternion quaternion, Quaternion quaternion2, float f) {
        float f2 = quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z + quaternion.w * quaternion2.w;
        if (1.0f + f2 > (float)Math.E) {
            float f3;
            float f4;
            if (1.0f - f2 > (float)Math.E) {
                float f5 = MathFloat.acos(f2);
                float f6 = MathFloat.sin(f5);
                f4 = MathFloat.sin((1.0f - f) * f5) / f6;
                f3 = MathFloat.sin(f * f5) / f6;
            } else {
                f4 = 1.0f - f;
                f3 = f;
            }
            this.x = f4 * quaternion.x + f3 * quaternion2.x;
            this.y = f4 * quaternion.y + f3 * quaternion2.y;
            this.z = f4 * quaternion.z + f3 * quaternion2.z;
            this.w = f4 * quaternion.w + f3 * quaternion2.w;
        } else {
            this.x = -quaternion.y;
            this.y = quaternion.x;
            this.z = -quaternion.w;
            this.w = quaternion.z;
            float f7 = MathFloat.sin((1.0f - f) * (float)Math.PI * 0.5f);
            float f8 = MathFloat.sin(f * (float)Math.PI * 0.5f);
            this.x = f7 * quaternion.x + f8 * quaternion2.x;
            this.y = f7 * quaternion.y + f8 * quaternion2.y;
            this.z = f7 * quaternion.z + f8 * quaternion2.z;
        }
    }

    public boolean isEmpty() {
        return this.w == 1.0f && this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public boolean isIdentity() {
        return this.w == 0.0f && this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public void setFromMatrix(float[] fArray) {
        float f = fArray[0] + fArray[4] + fArray[8] + 1.0f;
        if (f > 0.0f) {
            float f2 = 0.5f / MathFloat.sqrt(f);
            this.w = 0.25f / f2;
            this.x = (fArray[5] - fArray[7]) * f2;
            this.y = (fArray[6] - fArray[2]) * f2;
            this.z = (fArray[1] - fArray[3]) * f2;
        } else if (fArray[0] > fArray[4] & fArray[0] > fArray[8]) {
            float f3 = MathFloat.sqrt(1.0f + fArray[0] - fArray[4] - fArray[8]) * 2.0f;
            this.w = (fArray[7] - fArray[5]) / f3;
            this.x = 0.25f * f3;
            this.y = (fArray[3] + fArray[1]) / f3;
            this.z = (fArray[6] + fArray[2]) / f3;
        } else if (fArray[4] > fArray[8]) {
            float f4 = MathFloat.sqrt(1.0f + fArray[4] - fArray[0] - fArray[8]) * 2.0f;
            this.w = (fArray[6] - fArray[2]) / f4;
            this.x = (fArray[3] + fArray[1]) / f4;
            this.y = 0.25f * f4;
            this.z = (fArray[7] + fArray[5]) / f4;
        } else {
            float f5 = MathFloat.sqrt(1.0f + fArray[8] - fArray[0] - fArray[4]) * 2.0f;
            this.w = (fArray[3] - fArray[1]) / f5;
            this.x = (fArray[6] + fArray[2]) / f5;
            this.y = (fArray[7] + fArray[5]) / f5;
            this.z = 0.25f * f5;
        }
    }

    public boolean isRotationMatrix(float[] fArray) {
        double d = 0.01;
        if ((double)MathFloat.abs(fArray[0] * fArray[3] + fArray[3] * fArray[4] + fArray[6] * fArray[7]) > d) {
            return false;
        }
        if ((double)MathFloat.abs(fArray[0] * fArray[2] + fArray[3] * fArray[5] + fArray[6] * fArray[8]) > d) {
            return false;
        }
        if ((double)MathFloat.abs(fArray[1] * fArray[2] + fArray[4] * fArray[5] + fArray[7] * fArray[8]) > d) {
            return false;
        }
        if ((double)MathFloat.abs(fArray[0] * fArray[0] + fArray[3] * fArray[3] + fArray[6] * fArray[6] - 1.0f) > d) {
            return false;
        }
        if ((double)MathFloat.abs(fArray[1] * fArray[1] + fArray[4] * fArray[4] + fArray[7] * fArray[7] - 1.0f) > d) {
            return false;
        }
        if ((double)MathFloat.abs(fArray[2] * fArray[2] + fArray[5] * fArray[5] + fArray[8] * fArray[8] - 1.0f) > d) {
            return false;
        }
        return (double)MathFloat.abs(this.determinant(fArray) - 1.0f) < d;
    }

    private float determinant(float[] fArray) {
        return fArray[0] * fArray[4] * fArray[8] + fArray[3] * fArray[7] * fArray[2] + fArray[6] * fArray[1] * fArray[5] - fArray[0] * fArray[7] * fArray[5] - fArray[3] * fArray[1] * fArray[8] - fArray[6] * fArray[4] * fArray[2];
    }
}

