/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.timeline.map;

import com.jogamp.opengl.util.gl2.GLUT;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.unreal.communication.messages.gbinfomessages.IPlayer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import nl.tudelft.goal.ut2004.visualizer.map.TeamShade;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.GLTools;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.GlColor;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.ISubGLRenderer;

public class PlayerRenderer
implements ISubGLRenderer<IPlayer> {
    private final double SPHERE_RADIUS = 60.0;
    private final int SPHERE_SLICES = 32;
    private final int SPHERE_STACKS = 32;
    private static final Color BLUE_TEAM_COLOR_DEFAULT = Color.BLUE;
    private static final Color RED_TEAM_COLOR_DEFAULT = Color.RED;
    private static final String BLUE_TEAM_COLOR_KEY = "BLUE_TEAM_COLOR_KEY";
    private static final String RED_TEAM_COLOR_KEY = "RED_TEAM_COLOR_KEY";
    private static final Preferences preferences = Preferences.userNodeForPackage(PlayerRenderer.class);
    private PreferenceChangeListener changeListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            PlayerRenderer.this.dirty = true;
            PlayerRenderer.this.color.setBlueTeam(PlayerRenderer.getBlueTeamColor());
            PlayerRenderer.this.color.setRedTeam(PlayerRenderer.getRedTeamColor());
        }
    };
    private boolean dirty = true;
    private final int glName;
    private final IPlayer agent;
    private final TeamShade color;

    public PlayerRenderer(IPlayer utAgent, int glName) {
        this.agent = utAgent;
        this.glName = glName;
        this.color = new TeamShade(PlayerRenderer.getRedTeamColor(), PlayerRenderer.getBlueTeamColor());
        preferences.addPreferenceChangeListener(this.changeListener);
    }

    @Override
    public void prepare(GL gl) {
    }

    @Override
    public IPlayer getObject() {
        return this.agent;
    }

    @Override
    public void render(GL gla) {
        GL2 gl = gla.getGL2();
        try {
            Location entityLocation = this.agent.getLocation();
            if (entityLocation == null) {
                return;
            }
            Location center = new Location(entityLocation.x, entityLocation.y, entityLocation.z + 66.0);
            GlColor color = new GlColor(this.getColor());
            gl.glLoadName(this.glName);
            this.renderAgent((GL)gl, color, center);
            gl.glLoadName(-1);
            this.renderInfo((GL)gl, color, center);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void renderAgent(GL gla, GlColor color, Location position) {
        GLU glu = new GLU();
        GLUquadric quadratic = glu.gluNewQuadric();
        GL2 gl = gla.getGL2();
        gl.glPushMatrix();
        gl.glTranslated(position.x, position.y, position.z);
        gl.glColor4d(color.r, color.g, color.b, color.a);
        glu.gluSphere(quadratic, 60.0, 32, 32);
        gl.glPopMatrix();
        Rotation rot = this.agent.getRotation();
        if (rot != null) {
            this.renderRotation((GL)gl, new GlColor(1.0, 0.0, 0.0), position, rot);
        }
    }

    private void renderRotation(GL gla, GlColor color, Location center, Rotation rotation) {
        GLUT glut = new GLUT();
        GL2 gl = gla.getGL2();
        gl.glPushMatrix();
        gl.glTranslated(center.x, center.y, center.z);
        Location endOfArrow = rotation.toLocation().getNormalized().scale(150.0);
        gl.glBegin(1);
        gl.glColor4d(color.r, color.g, color.b, color.a);
        gl.glVertex3d(0.0, 0.0, 0.0);
        gl.glVertex3d(endOfArrow.x, endOfArrow.y, endOfArrow.z);
        gl.glEnd();
        gl.glTranslated(endOfArrow.x, endOfArrow.y, endOfArrow.z);
        double yaw = rotation.getYaw() / 32767.0 * 180.0;
        double roll = rotation.getRoll() / 32767.0 * 180.0;
        double pitch = rotation.getPitch() / 32767.0 * 180.0;
        gl.glRotated(yaw, 0.0, 0.0, 1.0);
        gl.glRotated(90.0, 0.0, 1.0, 0.0);
        glut.glutSolidCone(20.0, 40.0, 16, 16);
        gl.glPopMatrix();
    }

    private void renderInfo(GL gla, GlColor color, Location location) {
        GLU glu = new GLU();
        GLUT glut = new GLUT();
        GL2 gl = gla.getGL2();
        ArrayList<String> infos = new ArrayList<String>();
        infos.add(0, '*' + this.agent.getName() + '*');
        Location topHead = new Location(location.x, location.y, location.z + 132.0);
        Location top2d = GLTools.getScreenCoordinates((GL)gl, glu, topHead);
        int lineGap = 12;
        int font = 6;
        int maxWidth = 0;
        for (String line : infos) {
            int lineWidth = glut.glutBitmapLength(font, line);
            if (lineWidth <= maxWidth) continue;
            maxWidth = lineWidth;
        }
        top2d = new Location(top2d.x - (double)(maxWidth / 2), top2d.y + (double)((infos.size() - 1) * lineGap), top2d.z);
        GlColor textColor = color.getMixedWith(new GlColor(0.0, 0.0, 0.0), 80.0);
        gl.glColor3d(textColor.r, textColor.g, textColor.b);
        for (int i = 0; i < infos.size(); ++i) {
            String text = (String)infos.get(i);
            if (i == 0) {
                gl.glColor3d(color.r, color.g, color.b);
            } else {
                gl.glColor3d(textColor.r, textColor.g, textColor.b);
            }
            Location textPos = GLTools.getWorldCoordinates((GL)gl, glu, top2d);
            gl.glRasterPos3d(textPos.x, textPos.y, textPos.z);
            glut.glutBitmapString(font, text);
            top2d = top2d.addY((double)(-lineGap));
        }
    }

    public Color getColor() {
        return this.color.getColor(this.agent.getTeam());
    }

    public static Color getRedTeamColor() {
        int rgb = preferences.getInt(RED_TEAM_COLOR_KEY, RED_TEAM_COLOR_DEFAULT.getRGB());
        return new Color(rgb);
    }

    public static void setRedTeamColor(Color c) {
        preferences.putInt(RED_TEAM_COLOR_KEY, c.getRGB());
    }

    public static Color getBlueTeamColor() {
        int rgb = preferences.getInt(BLUE_TEAM_COLOR_KEY, BLUE_TEAM_COLOR_DEFAULT.getRGB());
        return new Color(rgb);
    }

    public static void setBlueTeamColor(Color c) {
        preferences.putInt(BLUE_TEAM_COLOR_KEY, c.getRGB());
    }

    @Override
    public int getGLName() {
        return this.glName;
    }

    @Override
    public void destroy() {
        preferences.removePreferenceChangeListener(this.changeListener);
    }
}

