/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.timeline.map;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.gl2.GLUT;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.gbinfomessages.IPlayer;
import java.awt.Point;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.vecmath.Vector3d;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.CollectionRenderer;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.MapRenderer;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.MapViewpoint;

public class EnvironmentRenderer
implements GLEventListener {
    private static GLU glu = new GLU();
    private static GLUT glut = new GLUT();
    private MapViewpoint viewpoint;
    private CollectionRenderer<IPlayer> agentRenderes;
    private CollectionRenderer<Object> objectRenderes;
    private MapRenderer mapRenderer;
    private boolean selectDirtyFlag = true;
    private Point selectPoint = new Point();
    private int[] selectedObjects = new int[0];

    public EnvironmentRenderer(MapViewpoint viewpoint, CollectionRenderer<IPlayer> agentRenderes, CollectionRenderer<Object> objectRenderes, MapRenderer mapRenderer) {
        this.viewpoint = viewpoint;
        this.agentRenderes = agentRenderes;
        this.objectRenderes = objectRenderes;
        this.mapRenderer = mapRenderer;
    }

    public synchronized void init(GLAutoDrawable glDrawable) {
        GL2 gl = glDrawable.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glEnable(2929);
        gl.glBlendFunc(770, 771);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glClearDepth(1.0);
        gl.glShadeModel(7425);
        gl.glDisable(2896);
        this.agentRenderes.prepare((GL)gl);
        this.objectRenderes.prepare((GL)gl);
        this.mapRenderer.prepare((GL)gl);
    }

    public synchronized void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        this.setProjection(gl, x, y, width, height);
    }

    private synchronized void setProjection(GL2 gl, int x, int y, int width, int height) {
        if (height <= 0) {
            height = 1;
        }
        float h = (float)width / (float)height;
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluPerspective(this.viewpoint.getViewAngle(), (double)h, 10.0, 100000.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    private synchronized void prepareCanvas(GL2 gl) {
        gl.glEnable(2929);
        gl.glClearColor(0.45f, 0.45f, 0.45f, 0.0f);
        gl.glClear(16640);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        Location observerLoc = this.viewpoint.getLocation();
        Location eyeLoc = this.viewpoint.getEye();
        Vector3d upVec = this.viewpoint.getUp();
        glu.gluLookAt(eyeLoc.x, eyeLoc.y, eyeLoc.z, observerLoc.x, observerLoc.y, observerLoc.z, upVec.x, upVec.y, upVec.z);
        gl.glScaled(1.0, 1.0, -1.0);
    }

    public synchronized void display(GLAutoDrawable glDrawable) {
        GL2 gl = glDrawable.getGL().getGL2();
        int[] viewport = new int[4];
        gl.glGetIntegerv(2978, viewport, 0);
        int[] selectBufferArray = new int[512];
        IntBuffer selectBuffer = Buffers.newDirectIntBuffer((int)selectBufferArray.length);
        gl.glSelectBuffer(selectBufferArray.length, selectBuffer);
        gl.glRenderMode(7170);
        gl.glInitNames();
        gl.glPushName(-1);
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        glu.gluPickMatrix((float)this.selectPoint.x, (float)(viewport[3] - this.selectPoint.y), 1.0f, 1.0f, viewport, 0);
        glu.gluPerspective(this.viewpoint.getViewAngle(), (double)((float)viewport[2] / (float)viewport[3]), 10.0, 100000.0);
        this.prepareCanvas(gl);
        this.mapRenderer.render((GL)gl);
        this.agentRenderes.render((GL)gl);
        this.objectRenderes.render((GL)gl);
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        int numOfHits = gl.glRenderMode(7168);
        selectBuffer.get(selectBufferArray);
        this.selectedObjects = new int[numOfHits];
        for (int hitIndex = 0; hitIndex < numOfHits; ++hitIndex) {
            this.selectedObjects[hitIndex] = selectBufferArray[hitIndex * 4 + 3];
        }
        this.selectDirtyFlag = false;
        this.prepareCanvas(gl);
        this.mapRenderer.render((GL)gl);
        this.agentRenderes.render((GL)gl);
        this.objectRenderes.render((GL)gl);
        String res = "[" + this.selectPoint.x + ", " + this.selectPoint.y + "] # " + numOfHits;
        for (int objId : this.selectedObjects) {
            res = res + ":" + objId;
        }
        this.renderText(gl, res, 0, 0, 7);
    }

    private void renderText(GL2 gl, String text, int x, int y, int font) {
        int[] viewport = new int[4];
        gl.glGetIntegerv(2978, viewport, 0);
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)viewport[2], 0.0, (double)viewport[3], -1.0, 1.0);
        gl.glColor3d(1.0, 1.0, 1.0);
        gl.glRasterPos3d(0.0, 0.0, 0.0);
        glut.glutBitmapString(font, text);
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
    }

    public synchronized int[] getSelectedObjects() throws IllegalStateException {
        if (this.selectDirtyFlag) {
            throw new IllegalStateException("Not objects from selected point. Did you call display() after setSelectPoint()?");
        }
        return Arrays.copyOf(this.selectedObjects, this.selectedObjects.length);
    }

    public synchronized void setSelectPoint(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("Point cannot be null");
        }
        this.selectPoint = new Point(point);
        this.selectDirtyFlag = true;
    }

    public void dispose(GLAutoDrawable arg0) {
    }
}

