/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.map;

import java.awt.Color;
import java.util.Random;

public class MapColorGenerator {
    private Random random = new Random();

    private Color getUniqueColor() {
        return new Color(this.random.nextFloat(), this.random.nextFloat(), this.random.nextFloat());
    }

    public MapColor getUniqueTeamColor() {
        return new MapColor(this.getUniqueColor());
    }

    private Color mix(Color a, Color b, double portion) {
        double thisPortion = 1.0 - portion;
        return new Color((int)(thisPortion * (double)a.getRed()) + (int)(portion * (double)b.getRed()), (int)(thisPortion * (double)a.getGreen()) + (int)(portion * (double)b.getGreen()), (int)(thisPortion * (double)a.getBlue()) + (int)(portion * (double)b.getBlue()), (int)(thisPortion * (double)a.getAlpha()) + (int)(portion * (double)b.getAlpha()));
    }

    public void freeColor(Color color) {
    }

    public class MapColor {
        private final Color otherTeam;
        private final Color redTeam;
        private final Color blueTeam;
        private static final double TEAM_COLOR_STRENGHT = 0.25;

        public MapColor(Color baseColor) {
            this.otherTeam = baseColor;
            this.redTeam = MapColorGenerator.this.mix(Color.red, baseColor, 0.25);
            this.blueTeam = MapColorGenerator.this.mix(Color.blue, baseColor, 0.25);
        }

        public Color getColor(int team) {
            switch (team) {
                case 0: {
                    return this.redTeam;
                }
                case 1: {
                    return this.blueTeam;
                }
            }
            return this.otherTeam;
        }
    }
}

