/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.controller;

import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.utils.flag.FlagListener;
import nl.tudelft.goal.ut2004.visualizer.data.EnvironmentData;
import nl.tudelft.goal.ut2004.visualizer.data.GameData;
import nl.tudelft.goal.ut2004.visualizer.data.GameStatusData;
import nl.tudelft.pogamut.base.server.ReconnectingServerDefinition;
import nl.tudelft.pogamut.base.server.ServerDefinition;
import nl.tudelft.pogamut.ut2004.server.UTServerDefinition;

public class ServerController {
    private final ServerDefinition<IUT2004Server> serverDefinition;
    private final GameData gameData;
    private final GameStatusData gameStatus;
    private final EnvironmentData environmentData;
    private static ServerController singleton;

    private ServerController() {
        UTServerDefinition utServerDefinition = new UTServerDefinition();
        this.serverDefinition = new ReconnectingServerDefinition((ServerDefinition)utServerDefinition);
        this.gameData = new GameData();
        this.gameStatus = new GameStatusData();
        this.environmentData = new EnvironmentData();
        this.environmentData.connect();
        this.addServerListener();
        this.init();
    }

    private void addServerListener() {
        this.serverDefinition.getServerFlag().addListener((FlagListener)new FlagListener<IUT2004Server>(){

            public synchronized void flagChanged(IUT2004Server server) {
                ServerController.this.gameData.serverChanged(server);
                ServerController.this.gameStatus.serverChanged(server);
            }
        });
    }

    private void init() {
        IUT2004Server server = (IUT2004Server)this.serverDefinition.getServerFlag().getFlag();
        if (server != null) {
            this.gameData.serverChanged(server);
            this.gameStatus.serverChanged(server);
        }
    }

    public GameData getGameData() {
        return this.gameData;
    }

    public GameStatusData getGameStatus() {
        return this.gameStatus;
    }

    public ServerDefinition<IUT2004Server> getServerDefinition() {
        return this.serverDefinition;
    }

    public IUT2004Server getServer() {
        return (IUT2004Server)this.serverDefinition.getServerFlag().getFlag();
    }

    public EnvironmentData getEnvironmentData() {
        return this.environmentData;
    }

    private void dispose() {
        this.serverDefinition.stopServer();
    }

    public static void createNewController() {
        ServerController.disposeController();
        singleton = new ServerController();
    }

    public static void disposeController() {
        if (singleton != null) {
            singleton.dispose();
            singleton = null;
        }
    }

    public static ServerController getInstance() {
        return singleton;
    }
}

