/*
 * Decompiled with CFR 0.152.
 */
package eis.eis2java.handlers;

import eis.eis2java.exception.TranslationException;
import eis.eis2java.handlers.ActionHandler;
import eis.eis2java.translation.Translator;
import eis.eis2java.util.EIS2JavaUtil;
import eis.exceptions.ActException;
import eis.exceptions.EntityException;
import eis.iilang.Action;
import eis.iilang.Parameter;
import eis.iilang.Percept;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Map;

public class DefaultActionHandler
extends ActionHandler {
    protected final Map<String, Method> actionMethods;
    protected final Object entity;

    public DefaultActionHandler(Object entity) throws EntityException {
        this.entity = entity;
        this.actionMethods = EIS2JavaUtil.processActionAnnotations(entity.getClass());
    }

    @Override
    public final boolean isSupportedByEntity(Action action) {
        String actionName = EIS2JavaUtil.getNameOfAction(action);
        return this.actionMethods.get(actionName) != null;
    }

    @Override
    public final Percept performAction(Action action) throws ActException {
        String actionName = EIS2JavaUtil.getNameOfAction(action);
        Method actionMethod = this.actionMethods.get(actionName);
        if (actionMethod == null) {
            throw new ActException(7, "Entity does not support action: " + action);
        }
        try {
            return this.performAction(this.entity, actionMethod, action);
        }
        catch (Exception e) {
            if (e instanceof ActException) {
                throw (ActException)e;
            }
            throw new ActException(7, "execution of action " + action + "failed", e);
        }
    }

    private Percept performAction(Object entity, Method method, Action action) throws ActException {
        Object returnValue;
        Translator translator = Translator.getInstance();
        Class<?>[] parameterTypes = method.getParameterTypes();
        LinkedList<Parameter> parameters = action.getParameters();
        Object[] arguments = new Object[parameters.size()];
        int i = 0;
        for (Parameter parameter : parameters) {
            try {
                arguments[i] = translator.translate2Java(parameter, parameterTypes[i]);
            }
            catch (TranslationException e) {
                throw new ActException(7, "Action " + action.getName() + " with parameters " + parameters + " failed to be translated", e);
            }
            ++i;
        }
        try {
            returnValue = method.invoke(entity, arguments);
        }
        catch (IllegalArgumentException e) {
            throw new ActException(7, "Action " + action.getName() + " with parameters " + parameters + " failed to execute", e);
        }
        catch (IllegalAccessException e) {
            throw new ActException(7, "Action " + action.getName() + " with parameters " + parameters + " failed to execute", e);
        }
        catch (InvocationTargetException e) {
            throw new ActException(7, "Action " + action.getName() + " with parameters " + parameters + " failed to execute", e);
        }
        if (returnValue == null) {
            return null;
        }
        try {
            return new Percept(action.getName(), translator.translate2Parameter(returnValue));
        }
        catch (TranslationException e) {
            throw new ActException(7, "Action " + action.getName() + " with parameters " + parameters + " failed to return a proper failue", e);
        }
    }
}

