/*
 * Decompiled with CFR 0.152.
 */
package eis;

import eis.EnvironmentInterfaceStandard;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class EILoader {
    private static String version = "0.3";

    public static EnvironmentInterfaceStandard fromJarFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("\"" + file.getAbsolutePath() + "\" does not exist.");
        }
        if (!file.getName().endsWith(".jar")) {
            throw new IOException("\"" + file.getAbsolutePath() + "\" is not a jar-file.");
        }
        JarFile jarFile = new JarFile(file);
        Manifest manifest = jarFile.getManifest();
        String mainClass = manifest.getMainAttributes().getValue("Main-Class");
        if (mainClass == null || mainClass.equals("")) {
            throw new IOException(file + "does not specify a main-class");
        }
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        URL url = file.toURI().toURL();
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, url);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader", t);
        }
        URLClassLoader loader = new URLClassLoader(new URL[]{url});
        Class<?> envInterfaceClass = null;
        try {
            envInterfaceClass = loader.loadClass(mainClass);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Class \"" + mainClass + "\" could not be loaded from \"" + file + "\"", e);
        }
        Constructor<?> c = null;
        EnvironmentInterfaceStandard ei = null;
        try {
            c = envInterfaceClass.getConstructor(new Class[0]);
            ei = (EnvironmentInterfaceStandard)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.out.println(e);
            throw new IOException("Class \"" + mainClass + "\" could not be loaded from \"" + file + "\"", e);
        }
        if (!version.equals(ei.requiredVersion())) {
            throw new IOException("Loaded environment interface version does not match the required one \"" + version + "\" vs. \"" + ei.requiredVersion() + "\"");
        }
        return ei;
    }

    public static EnvironmentInterfaceStandard fromClassName(String className) throws IOException {
        ClassLoader loader = EnvironmentInterfaceStandard.class.getClassLoader();
        Class<?> envInterfaceClass = null;
        try {
            envInterfaceClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Class \"" + className + "\" could not be loaded", e);
        }
        Constructor<?> c = null;
        EnvironmentInterfaceStandard ei = null;
        try {
            c = envInterfaceClass.getConstructor(new Class[0]);
            ei = (EnvironmentInterfaceStandard)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.out.println(e);
            throw new IOException("Class \"" + className + "\" could not be loaded", e);
        }
        if (!version.equals(ei.requiredVersion())) {
            throw new IOException("Loaded environment interface version does not match the required one \"" + version + "\" vs. \"" + ei.requiredVersion() + "\"");
        }
        return ei;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("You have to provide a filename.");
        } else {
            EnvironmentInterfaceStandard environmentInterfaceStandard = EILoader.fromJarFile(new File(args[0]));
        }
    }
}

