/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.base.server;

import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import java.net.URI;
import nl.tudelft.pogamut.base.server.ServerDefinition;

public final class ReconnectingServerDefinition<T>
extends ServerDefinition<T> {
    private static final long serialVersionUID = 866197741748535623L;
    private final FlagListener<T> serverListener = new FlagListener<T>(){

        public void flagChanged(T server) {
            if (server == null) {
                ReconnectingServerDefinition.this.startServer();
            }
        }
    };
    private final ServerDefinition<T> serverDefinition;
    private StartServerThread startServerThread;

    public ReconnectingServerDefinition(ServerDefinition<T> serverDefinition) {
        this.serverDefinition = serverDefinition;
        this.serverDefinition.getServerFlag().addListener(this.serverListener);
    }

    @Override
    public void setServerName(String name) {
        this.serverDefinition.setServerName(name);
    }

    @Override
    public String getServerName() {
        return this.serverDefinition.getServerName();
    }

    @Override
    public Flag<String> getServerNameFlag() {
        return this.serverDefinition.getServerNameFlag();
    }

    @Override
    public void setUri(URI uri) {
        this.startServer(uri);
    }

    @Override
    public URI getUri() {
        if (this.serverDefinition == null) {
            return null;
        }
        return this.serverDefinition.getUri();
    }

    @Override
    public Flag<URI> getUriFlag() {
        return this.serverDefinition.getUriFlag();
    }

    @Override
    protected void setNewServer(T server) {
        this.serverDefinition.setNewServer(server);
    }

    @Override
    public Flag<T> getServerFlag() {
        return this.serverDefinition.getServerFlag();
    }

    @Override
    public void stopServer() {
        this.serverDefinition.getServerFlag().removeListener(this.serverListener);
        if (this.startServerThread != null && this.startServerThread.isAlive()) {
            this.startServerThread.cancel();
        }
        this.startServerThread = null;
        this.serverDefinition.stopServer();
    }

    @Override
    public void startServer() {
        this.startServer(this.serverDefinition.getUri());
    }

    private void startServer(URI uri) {
        this.stopServer();
        this.serverDefinition.getServerFlag().addListener(this.serverListener);
        this.startServerThread = new StartServerThread(uri);
        this.startServerThread.start();
    }

    private class StartServerThread
    extends Thread {
        private static final long RECONNECTION_DELAY = 15000L;
        private boolean tryAgain;
        private boolean connected;
        private final URI serverAddres;

        public StartServerThread(URI serverAddres) {
            super("ReconnectingServer: " + serverAddres);
            this.tryAgain = true;
            this.connected = false;
            this.serverAddres = serverAddres;
        }

        @Override
        public void run() {
            while (!this.connected && this.tryAgain) {
                try {
                    ReconnectingServerDefinition.this.serverDefinition.setUri(this.serverAddres);
                    this.connected = true;
                }
                catch (PogamutException pogamutException) {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public void cancel() {
            this.tryAgain = false;
        }

        public boolean isCancelled() {
            return this.tryAgain;
        }

        public boolean isDone() {
            return this.connected;
        }
    }
}

