/*
 * Decompiled with CFR 0.152.
 */
package eis.eis2java.util;

import eis.eis2java.annotation.AsAction;
import eis.eis2java.annotation.AsPercept;
import eis.exceptions.EntityException;
import eis.iilang.Action;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EIS2JavaUtil {
    public static Set<Method> processPerceptAnnotations(Class<?> clazz) throws EntityException {
        HashSet<Method> percepts = new HashSet<Method>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            AsPercept asPercept = method.getAnnotation(AsPercept.class);
            if (asPercept != null) {
                if (method.getParameterTypes().length != 0) {
                    throw new EntityException("Percepts may not have any arguments");
                }
                percepts.add(method);
            }
            ++n2;
        }
        return percepts;
    }

    public static Map<String, Method> processActionAnnotations(Class<?> clazz) throws EntityException {
        HashMap<String, Method> actions = new HashMap<String, Method>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            AsAction asAction = method.getAnnotation(AsAction.class);
            if (asAction != null) {
                String name = EIS2JavaUtil.getNameOfAction(method);
                if (actions.containsKey(name)) {
                    throw new EntityException("Found two action definitions with the same name: " + name);
                }
                actions.put(name, method);
            }
            ++n2;
        }
        return actions;
    }

    public static String getNameOfAction(Action action) {
        return String.valueOf(action.getName()) + "/" + action.getParameters().size();
    }

    public static String getNameOfAction(Method method) {
        AsAction annotation = method.getAnnotation(AsAction.class);
        if (annotation == null) {
            return null;
        }
        return String.valueOf(annotation.name()) + "/" + method.getParameterTypes().length;
    }

    public static String getNameOfPercept(Method method) {
        AsPercept annotation = method.getAnnotation(AsPercept.class);
        if (annotation == null) {
            return null;
        }
        return annotation.name();
    }
}

