/*
 * Decompiled with CFR 0.152.
 */
package eis.eis2java.util;

import eis.eis2java.annotation.AsPercept;
import eis.eis2java.util.EIS2JavaUtil;
import eis.exceptions.EntityException;
import eis.exceptions.PerceiveException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AllPerceptsModule {
    private final Set<Method> perceptProviders;
    private final Map<Method, Object> perceptBatch = new HashMap<Method, Object>();
    private final Map<Method, List<Object>> eventPerceptBatch = new HashMap<Method, List<Object>>();
    private final Object entity;

    public AllPerceptsModule(Object entity) throws EntityException {
        this.entity = entity;
        Class<?> clazz = entity.getClass();
        this.perceptProviders = EIS2JavaUtil.processPerceptAnnotations(clazz);
    }

    public synchronized void updatePercepts() throws PerceiveException {
        this.perceptBatch.clear();
        for (Method method : this.perceptProviders) {
            Object percept;
            AsPercept annotation = method.getAnnotation(AsPercept.class);
            String perceptName = annotation.name();
            try {
                percept = method.invoke(this.entity, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new PerceiveException("Unable to update " + perceptName, e);
            }
            catch (IllegalAccessException e) {
                throw new PerceiveException("Unable to update " + perceptName, e);
            }
            catch (InvocationTargetException e) {
                throw new PerceiveException("Unable to update " + perceptName, e);
            }
            if (annotation.event()) {
                if (!this.eventPerceptBatch.containsKey(method)) {
                    this.eventPerceptBatch.put(method, new ArrayList());
                }
                List<Object> events = this.eventPerceptBatch.get(method);
                if (!annotation.multiplePercepts()) {
                    throw new PerceiveException("Unable to update " + perceptName + " event percept must have multiplePercepts.");
                }
                if (!(percept instanceof Collection)) {
                    throw new PerceiveException("Unable to update " + perceptName + " return value must be a collection.");
                }
                events.addAll((Collection)percept);
                continue;
            }
            this.perceptBatch.put(method, percept);
        }
        this.perceptBatch.putAll(this.eventPerceptBatch);
    }

    public synchronized Map<Method, Object> getAllPercepts() {
        this.eventPerceptBatch.clear();
        return new HashMap<Method, Object>(this.perceptBatch);
    }
}

