/*
 * Decompiled with CFR 0.152.
 */
package eis;

import eis.AgentListener;
import eis.EnvironmentInterfaceStandard;
import eis.EnvironmentListener;
import eis.exceptions.ActException;
import eis.exceptions.AgentException;
import eis.exceptions.EntityException;
import eis.exceptions.EnvironmentInterfaceException;
import eis.exceptions.ManagementException;
import eis.exceptions.NoEnvironmentException;
import eis.exceptions.PerceiveException;
import eis.exceptions.RelationException;
import eis.iilang.Action;
import eis.iilang.EnvironmentState;
import eis.iilang.Parameter;
import eis.iilang.Percept;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EIDefaultImpl
implements EnvironmentInterfaceStandard,
Serializable {
    private static final long serialVersionUID = 3728998641924854414L;
    private LinkedList<String> registeredAgents = null;
    private LinkedList<String> entities = null;
    private ConcurrentHashMap<String, HashSet<String>> agentsToEntities = null;
    private Vector<EnvironmentListener> environmentListeners = new Vector();
    private ConcurrentHashMap<String, HashSet<AgentListener>> agentsToAgentListeners = new ConcurrentHashMap();
    private HashMap<String, String> entitiesToTypes = null;
    private EnvironmentState state = null;

    public EIDefaultImpl() {
        this.registeredAgents = new LinkedList();
        this.entities = new LinkedList();
        this.agentsToEntities = new ConcurrentHashMap();
        this.entitiesToTypes = new HashMap();
        this.state = EnvironmentState.INITIALIZING;
    }

    @Override
    public void reset(Map<String, Parameter> parameters) throws ManagementException {
        this.state = EnvironmentState.PAUSED;
    }

    @Override
    public void attachEnvironmentListener(EnvironmentListener listener) {
        if (!this.environmentListeners.contains(listener)) {
            this.environmentListeners.add(listener);
        }
    }

    @Override
    public void detachEnvironmentListener(EnvironmentListener listener) {
        if (this.environmentListeners.contains(listener)) {
            this.environmentListeners.remove(listener);
        }
    }

    @Override
    public void attachAgentListener(String agent, AgentListener listener) {
        if (!this.registeredAgents.contains(agent)) {
            return;
        }
        HashSet<AgentListener> listeners = this.agentsToAgentListeners.get(agent);
        if (listeners == null) {
            listeners = new HashSet();
        }
        listeners.add(listener);
        this.agentsToAgentListeners.put(agent, listeners);
    }

    @Override
    public void detachAgentListener(String agent, AgentListener listener) {
        if (!this.registeredAgents.contains(agent)) {
            return;
        }
        HashSet<AgentListener> listeners = this.agentsToAgentListeners.get(agent);
        if (listeners == null || !listeners.contains(agent)) {
            return;
        }
        listeners.remove(listener);
    }

    protected void notifyAgents(Percept percept, String ... agents) throws EnvironmentInterfaceException {
        if (agents == null) {
            for (String agent : this.registeredAgents) {
                HashSet<AgentListener> agentListeners = this.agentsToAgentListeners.get(agent);
                if (agentListeners == null) continue;
                for (AgentListener listener : agentListeners) {
                    listener.handlePercept(agent, percept);
                }
            }
            return;
        }
        String[] stringArray = agents;
        int n = agents.length;
        int n2 = 0;
        while (n2 < n) {
            String agent = stringArray[n2];
            if (!this.registeredAgents.contains(agent)) {
                throw new EnvironmentInterfaceException("Agent " + agent + " has not registered to the environment.");
            }
            HashSet<AgentListener> agentListeners = this.agentsToAgentListeners.get(agent);
            if (agentListeners != null) {
                for (AgentListener listener : agentListeners) {
                    listener.handlePercept(agent, percept);
                }
            }
            ++n2;
        }
    }

    protected void notifyAgentsViaEntity(Percept percept, String ... pEntities) throws EnvironmentInterfaceException {
        Object object = pEntities;
        int n = pEntities.length;
        int n2 = 0;
        while (n2 < n) {
            String entity2 = object[n2];
            if (!this.entities.contains(entity2)) {
                throw new EnvironmentInterfaceException("entity \"" + entity2 + "\" does not exist.");
            }
            ++n2;
        }
        if (pEntities.length == 0) {
            for (String entity : this.entities) {
                for (Map.Entry entry : this.agentsToEntities.entrySet()) {
                    if (!((HashSet)entry.getValue()).contains(entity)) continue;
                    this.notifyAgents(percept, (String)entry.getKey());
                }
            }
        } else {
            object = pEntities;
            int n3 = pEntities.length;
            n2 = 0;
            while (n2 < n3) {
                String entity;
                entity = object[n2];
                for (Map.Entry<String, HashSet<String>> entry : this.agentsToEntities.entrySet()) {
                    if (!entry.getValue().contains(entity)) continue;
                    this.notifyAgents(percept, entry.getKey());
                }
                ++n2;
            }
        }
    }

    protected void notifyFreeEntity(String entity, Collection<String> agents) {
        for (EnvironmentListener listener : this.environmentListeners) {
            listener.handleFreeEntity(entity, agents);
        }
    }

    private void notifyIfFree(Set<String> entities, List<String> agents) {
        Collection free = this.getFreeEntities();
        for (String en : entities) {
            if (!free.contains(en)) continue;
            this.notifyFreeEntity(en, agents);
        }
    }

    protected void notifyNewEntity(String entity) {
        for (EnvironmentListener listener : this.environmentListeners) {
            listener.handleNewEntity(entity);
        }
    }

    protected void notifyDeletedEntity(String entity, Collection<String> agents) {
        for (EnvironmentListener listener : this.environmentListeners) {
            listener.handleDeletedEntity(entity, agents);
        }
    }

    @Override
    public void registerAgent(String agent) throws AgentException {
        if (this.registeredAgents.contains(agent)) {
            throw new AgentException("Agent " + agent + " has already registered to the environment.");
        }
        this.registeredAgents.add(agent);
    }

    @Override
    public void unregisterAgent(String agent) throws AgentException {
        if (!this.registeredAgents.contains(agent)) {
            throw new AgentException("Agent " + agent + " has not registered to the environment.");
        }
        this.agentsToEntities.remove(agent);
        this.agentsToAgentListeners.remove(agent);
        this.registeredAgents.remove(agent);
    }

    public LinkedList<String> getAgents() {
        return (LinkedList)this.registeredAgents.clone();
    }

    public LinkedList<String> getEntities() {
        return (LinkedList)this.entities.clone();
    }

    @Override
    public void associateEntity(String agent, String entity) throws RelationException {
        if (!this.entities.contains(entity)) {
            throw new RelationException("Entity \"" + entity + "\" does not exist!");
        }
        if (!this.registeredAgents.contains(agent)) {
            throw new RelationException("Agent \"" + agent + "\" has not been registered!");
        }
        HashSet<String> ens = this.agentsToEntities.get(agent);
        if (ens == null) {
            ens = new HashSet();
        }
        ens.add(entity);
        this.agentsToEntities.put(agent, ens);
    }

    @Override
    public void freeEntity(String entity) throws RelationException, EntityException {
        if (!this.entities.contains(entity)) {
            throw new EntityException("Entity \"" + entity + "\" does not exist!");
        }
        LinkedList<String> agents = new LinkedList<String>();
        boolean associated = false;
        for (Map.Entry<String, HashSet<String>> entry : this.agentsToEntities.entrySet()) {
            String agent = entry.getKey();
            HashSet<String> ens = entry.getValue();
            if (!ens.contains(entity)) continue;
            ens.remove(entity);
            this.agentsToEntities.put(agent, ens);
            associated = true;
            if (agents.contains(agent)) break;
            agents.add(agent);
            break;
        }
        if (!associated) {
            throw new RelationException("Entity \"" + entity + "\" has not been associated!");
        }
        this.notifyFreeEntity(entity, agents);
    }

    @Override
    public void freeAgent(String agent) throws RelationException {
        if (!this.registeredAgents.contains(agent)) {
            throw new RelationException("Agent \"" + agent + "\" does not exist!");
        }
        HashSet<String> ens = this.agentsToEntities.get(agent);
        LinkedList<String> agents = new LinkedList<String>();
        agents.add(agent);
        this.notifyIfFree(ens, agents);
        this.agentsToEntities.remove(agent);
    }

    @Override
    public void freePair(String agent, String entity) throws RelationException {
        if (!this.registeredAgents.contains(agent)) {
            throw new RelationException("Agent \"" + agent + "\" does not exist!");
        }
        if (!this.entities.contains(entity)) {
            throw new RelationException("Entity \"" + entity + "\" does not exist!");
        }
        HashSet<String> ens = this.agentsToEntities.get(agent);
        if (ens == null || !ens.contains(entity)) {
            throw new RelationException("Agent \"" + agent + " is not associated with entity \"" + entity + "\"!");
        }
        ens.remove(entity);
        this.agentsToEntities.put(agent, ens);
        LinkedList<String> agents = new LinkedList<String>();
        agents.add(agent);
        this.notifyIfFree(ens, agents);
    }

    public HashSet<String> getAssociatedEntities(String agent) throws AgentException {
        if (!this.registeredAgents.contains(agent)) {
            throw new AgentException("Agent \"" + agent + "\" has not been registered.");
        }
        HashSet<String> ret = this.agentsToEntities.get(agent);
        if (ret == null) {
            ret = new HashSet();
        }
        return ret;
    }

    public HashSet<String> getAssociatedAgents(String entity) throws EntityException {
        if (!this.entities.contains(entity)) {
            throw new EntityException("Entity \"" + entity + "\" has not been registered.");
        }
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<String, HashSet<String>> entry : this.agentsToEntities.entrySet()) {
            if (!entry.getValue().contains(entity)) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    public LinkedList<String> getFreeEntities() {
        Collection free = this.getEntities();
        for (String agent : this.agentsToEntities.keySet()) {
            ((AbstractCollection)free).removeAll((Collection)this.agentsToEntities.get(agent));
        }
        return free;
    }

    @Override
    public final Map<String, Percept> performAction(String agent, Action action, String ... entities) throws ActException {
        String type;
        String entity;
        int n;
        int n2;
        String[] stringArray;
        if (!this.registeredAgents.contains(agent)) {
            throw new ActException(1);
        }
        HashSet<String> associatedEntities = this.agentsToEntities.get(agent);
        if (associatedEntities == null || associatedEntities.size() == 0) {
            throw new ActException(2);
        }
        HashSet<String> targetEntities = null;
        if (entities.length == 0) {
            targetEntities = associatedEntities;
        } else {
            targetEntities = new HashSet();
            stringArray = entities;
            n2 = entities.length;
            n = 0;
            while (n < n2) {
                entity = stringArray[n];
                if (!associatedEntities.contains(entity)) {
                    throw new ActException(3);
                }
                targetEntities.add(entity);
                ++n;
            }
        }
        if (!this.isSupportedByEnvironment(action)) {
            throw new ActException(4);
        }
        stringArray = entities;
        n2 = entities.length;
        n = 0;
        while (n < n2) {
            block19: {
                entity = stringArray[n];
                try {
                    type = this.getType(entity);
                }
                catch (EntityException e) {
                    e.printStackTrace();
                    break block19;
                }
                if (!this.isSupportedByType(action, type)) {
                    throw new ActException(5);
                }
            }
            ++n;
        }
        stringArray = entities;
        n2 = entities.length;
        n = 0;
        while (n < n2) {
            block20: {
                entity = stringArray[n];
                try {
                    type = this.getType(entity);
                }
                catch (EntityException e) {
                    e.printStackTrace();
                    break block20;
                }
                if (!this.isSupportedByEntity(action, entity)) {
                    throw new ActException(6);
                }
            }
            ++n;
        }
        HashMap<String, Percept> ret = new HashMap<String, Percept>();
        for (String entity2 : targetEntities) {
            try {
                Percept p = this.performEntityAction(entity2, action);
                if (p == null) continue;
                ret.put(entity2, p);
            }
            catch (Exception e) {
                if (!(e instanceof ActException)) {
                    throw new ActException(7, "failure performing action", e);
                }
                throw (ActException)e;
            }
        }
        return ret;
    }

    @Override
    public Map<String, Collection<Percept>> getAllPercepts(String agent, String ... entities) throws PerceiveException, NoEnvironmentException {
        if (this.state != EnvironmentState.RUNNING) {
            throw new PerceiveException("Environment does not run");
        }
        if (!this.registeredAgents.contains(agent)) {
            throw new PerceiveException("Agent \"" + agent + "\" is not registered.");
        }
        HashSet<String> associatedEntities = this.agentsToEntities.get(agent);
        if (associatedEntities == null || associatedEntities.size() == 0) {
            throw new PerceiveException("Agent \"" + agent + "\" has no associated entities.");
        }
        HashMap<String, Collection<Percept>> ret = new HashMap<String, Collection<Percept>>();
        if (entities.length == 0) {
            for (String entity : associatedEntities) {
                LinkedList<Percept> all = this.getAllPerceptsFromEntity(entity);
                for (Percept p : all) {
                    p.setSource(entity);
                }
                ret.put(entity, all);
            }
        } else {
            String[] stringArray = entities;
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                String entity = stringArray[n2];
                if (!associatedEntities.contains(entity)) {
                    throw new PerceiveException("Entity \"" + entity + "\" has not been associated with the agent \"" + agent + "\".");
                }
                LinkedList<Percept> all = this.getAllPerceptsFromEntity(entity);
                for (Percept p : all) {
                    p.setSource(entity);
                }
                ret.put(entity, all);
                ++n2;
            }
        }
        return ret;
    }

    protected abstract LinkedList<Percept> getAllPerceptsFromEntity(String var1) throws PerceiveException, NoEnvironmentException;

    protected abstract boolean isSupportedByEnvironment(Action var1);

    protected abstract boolean isSupportedByType(Action var1, String var2);

    protected abstract boolean isSupportedByEntity(Action var1, String var2);

    protected abstract Percept performEntityAction(String var1, Action var2) throws ActException;

    @Override
    public String getType(String entity) throws EntityException {
        if (!this.entities.contains(entity)) {
            throw new EntityException("Entity \"" + entity + "\" does not exist!");
        }
        String type = this.entitiesToTypes.get(entity);
        if (type == null) {
            type = "unknown";
        }
        return type;
    }

    protected void addEntity(String entity) throws EntityException {
        if (this.entities.contains(entity)) {
            throw new EntityException("Entity \"" + entity + "\" does already exist");
        }
        this.entities.add(entity);
        this.notifyNewEntity(entity);
    }

    protected void addEntity(String entity, String type) throws EntityException {
        if (this.entities.contains(entity)) {
            throw new EntityException("Entity \"" + entity + "\" does already exist");
        }
        this.entities.add(entity);
        this.setType(entity, type);
        this.notifyNewEntity(entity);
    }

    protected void deleteEntity(String entity) throws EntityException, RelationException {
        if (!this.entities.contains(entity)) {
            throw new EntityException("Entity \"" + entity + "\" does not exist!");
        }
        LinkedList<String> agents = new LinkedList<String>();
        for (Map.Entry<String, HashSet<String>> entry : this.agentsToEntities.entrySet()) {
            String agent = entry.getKey();
            HashSet<String> ens = entry.getValue();
            if (!ens.contains(entity)) continue;
            ens.remove(entity);
            this.agentsToEntities.put(agent, ens);
            if (agents.contains(agent)) break;
            agents.add(agent);
            break;
        }
        this.entities.remove(entity);
        if (this.entitiesToTypes.containsKey(entity)) {
            this.entitiesToTypes.remove(entity);
        }
        this.notifyDeletedEntity(entity, agents);
    }

    public void setType(String entity, String type) throws EntityException {
        if (!this.entities.contains(entity)) {
            throw new EntityException("Entity \"" + entity + "\" does not exist!");
        }
        if (this.entitiesToTypes.get(entity) != null) {
            throw new EntityException("Entity \"" + entity + "\" already has a type!");
        }
        this.entitiesToTypes.put(entity, type);
    }

    protected void setState(EnvironmentState state) throws ManagementException {
        if (!this.isStateTransitionValid(this.state, state)) {
            throw new ManagementException("Invalid state transition from " + this.state.toString() + " to  " + state.toString());
        }
        this.state = state;
        for (EnvironmentListener listener : this.environmentListeners) {
            listener.handleStateChange(state);
        }
    }

    @Override
    public boolean isStateTransitionValid(EnvironmentState oldState, EnvironmentState newState) {
        if (oldState == EnvironmentState.INITIALIZING && newState == EnvironmentState.INITIALIZING) {
            return true;
        }
        if (oldState == EnvironmentState.INITIALIZING && newState == EnvironmentState.PAUSED) {
            return true;
        }
        if (oldState == EnvironmentState.INITIALIZING && newState == EnvironmentState.KILLED) {
            return true;
        }
        if (oldState == EnvironmentState.PAUSED && newState == EnvironmentState.RUNNING) {
            return true;
        }
        if (oldState == EnvironmentState.RUNNING && newState == EnvironmentState.PAUSED) {
            return true;
        }
        if (oldState == EnvironmentState.PAUSED && newState == EnvironmentState.KILLED) {
            return true;
        }
        return oldState == EnvironmentState.RUNNING && newState == EnvironmentState.KILLED;
    }

    @Override
    public EnvironmentState getState() {
        return this.state;
    }

    @Override
    public boolean isInitSupported() {
        return true;
    }

    @Override
    public boolean isKillSupported() {
        return true;
    }

    @Override
    public boolean isPauseSupported() {
        return true;
    }

    @Override
    public boolean isStartSupported() {
        return true;
    }

    @Override
    public void init(Map<String, Parameter> parameters) throws ManagementException {
        if (!this.isInitSupported()) {
            throw new ManagementException("init is not supported");
        }
        this.setState(EnvironmentState.INITIALIZING);
    }

    @Override
    public void kill() throws ManagementException {
        if (!this.isKillSupported()) {
            throw new ManagementException("kill is not supported");
        }
        this.setState(EnvironmentState.KILLED);
    }

    @Override
    public void pause() throws ManagementException {
        if (!this.isPauseSupported()) {
            throw new ManagementException("pause is not supported");
        }
        this.setState(EnvironmentState.PAUSED);
    }

    @Override
    public void start() throws ManagementException {
        if (!this.isStartSupported()) {
            throw new ManagementException("start is not supported");
        }
        this.setState(EnvironmentState.RUNNING);
    }

    @Override
    public String queryProperty(String property) {
        return null;
    }

    @Override
    public String queryEntityProperty(String entity, String property) {
        return null;
    }
}

