/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;

public class PngChunkHIST
extends PngChunk {
    private int[] hist = new int[0];

    public PngChunkHIST(ImageInfo imageInfo) {
        super("hIST", imageInfo);
    }

    @Override
    public boolean mustGoBeforeIDAT() {
        return true;
    }

    @Override
    public boolean mustGoAfterPLTE() {
        return true;
    }

    @Override
    public void parseFromChunk(ChunkRaw chunkRaw) {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images accept a HIST chunk");
        }
        int n = chunkRaw.data.length / 2;
        this.hist = new int[n];
        for (int i = 0; i < this.hist.length; ++i) {
            this.hist[i] = PngHelper.readInt2fromBytes(chunkRaw.data, i * 2);
        }
    }

    @Override
    public ChunkRaw createChunk() {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images accept a HIST chunk");
        }
        ChunkRaw chunkRaw = null;
        chunkRaw = this.createEmptyChunk(this.hist.length * 2, true);
        for (int i = 0; i < this.hist.length; ++i) {
            PngHelper.writeInt2tobytes(this.hist[i], chunkRaw.data, i * 2);
        }
        return chunkRaw;
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkHIST pngChunkHIST = (PngChunkHIST)pngChunk;
        this.hist = new int[pngChunkHIST.hist.length];
        System.arraycopy(pngChunkHIST.hist, 0, this.hist, 0, pngChunkHIST.hist.length);
    }

    public int[] getHist() {
        return this.hist;
    }

    public void setHist(int[] nArray) {
        this.hist = nArray;
    }
}

