/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.opengl.FBObject;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLGraphicsConfigurationUtil;

public class GLFBODrawableImpl
extends GLDrawableImpl {
    final GLDrawableImpl parent;
    final FBObject fbo;
    int texUnit;
    int samplesTexUnit = 0;
    int width = 0;
    int height = 0;
    int samples = 0;

    protected GLFBODrawableImpl(GLDrawableFactoryImpl gLDrawableFactoryImpl, GLDrawableImpl gLDrawableImpl, NativeSurface nativeSurface, int n, int n2, int n3) {
        super(gLDrawableFactoryImpl, nativeSurface, false);
        this.parent = gLDrawableImpl;
        this.texUnit = n3;
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)nativeSurface.getGraphicsConfiguration().getChosenCapabilities();
        this.width = n;
        this.height = n2;
        this.samples = gLCapabilitiesImmutable.getNumSamples();
        this.fbo = new FBObject();
    }

    @Override
    protected void contextRealized(GLContext gLContext, boolean bl) {
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getChosenCapabilities();
        GL gL = gLContext.getGL();
        if (bl) {
            this.fbo.reset(gL, this.width, this.height, this.samples);
            this.samples = this.fbo.getNumSamples();
            if (this.samples > 0) {
                this.fbo.attachColorbuffer(gL, 0, gLCapabilitiesImmutable.getAlphaBits() > 0);
            } else {
                this.fbo.attachTexture2D(gL, 0, gLCapabilitiesImmutable.getAlphaBits() > 0);
            }
            if (gLCapabilitiesImmutable.getStencilBits() > 0) {
                this.fbo.attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH_STENCIL, 24);
            } else {
                this.fbo.attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH, 24);
            }
        } else if (null != this.fbo) {
            this.fbo.destroy(gL);
        }
    }

    @Override
    protected void contextMadeCurrent(GLContext gLContext, boolean bl) {
        GL gL = gLContext.getGL();
        if (bl) {
            this.fbo.bind(gL);
        } else {
            this.fbo.unbind(gL);
            gL.glActiveTexture(33984 + this.texUnit);
            this.fbo.use(gL, this.samples > 0 ? this.fbo.getSamplingSink() : (FBObject.TextureAttachment)this.fbo.getColorbuffer(0));
            if (this.samples > 0) {
                gL.glBindFramebuffer(36008, this.fbo.getReadFramebuffer());
            }
        }
    }

    @Override
    protected int getDefaultDrawFramebuffer() {
        return this.fbo.getWriteFramebuffer();
    }

    @Override
    protected int getDefaultReadFramebuffer() {
        return this.fbo.getReadFramebuffer();
    }

    public FBObject getFBObject() {
        return this.fbo;
    }

    public void setSize(GL gL, int n, int n2) throws GLException {
        this.width = n;
        this.height = n2;
        this.fbo.reset(gL, this.width, this.height, this.samples);
        this.samples = this.fbo.getNumSamples();
    }

    public void setSamples(GL gL, int n) throws GLException {
        this.samples = n;
        this.fbo.reset(gL, this.width, this.height, this.samples);
        this.samples = this.fbo.getNumSamples();
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        GLContext gLContext2 = this.parent.createContext(gLContext);
        gLContext2.setGLDrawable(this, false);
        return gLContext2;
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper() {
        return this.parent.getGLDynamicLookupHelper();
    }

    @Override
    protected void swapBuffersImpl() {
    }

    @Override
    protected void setRealizedImpl() {
        this.parent.setRealized(this.realized);
        if (this.realized) {
            MutableGraphicsConfiguration mutableGraphicsConfiguration = (MutableGraphicsConfiguration)this.surface.getGraphicsConfiguration();
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)mutableGraphicsConfiguration.getChosenCapabilities();
            GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixOffscreenGLCapabilities(gLCapabilitiesImmutable, true, false);
            mutableGraphicsConfiguration.setChosenCapabilities(gLCapabilitiesImmutable2);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

