/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl.awt;

import com.jogamp.nativewindow.awt.AWTWindowClosingProtocol;
import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.util.GLBuffers;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.beans.Beans;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import javax.media.opengl.Threading;
import javax.media.opengl.awt.AWTGLAutoDrawable;
import javax.swing.JPanel;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableHelper;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.awt.Java2D;
import jogamp.opengl.awt.Java2DGLContext;

public class GLJPanel
extends JPanel
implements AWTGLAutoDrawable,
WindowClosingProtocol {
    private static final boolean DEBUG = Debug.debug("GLJPanel");
    private GLDrawableHelper helper = new GLDrawableHelper();
    private volatile boolean isInitialized;
    private GLCapabilitiesImmutable offscreenCaps;
    private GLProfile glProfile;
    private GLDrawableFactoryImpl factory;
    private GLCapabilitiesChooser chooser;
    private GLContext shareWith;
    private int additionalCtxCreationFlags = 0;
    private int panelWidth = 0;
    private int panelHeight = 0;
    private boolean handleReshape = false;
    private boolean sendReshape = true;
    private Backend backend;
    private Updater updater = new Updater();
    private static boolean hardwareAccelerationDisabled = Debug.isPropertyDefined("jogl.gljpanel.nohw", true);
    private static boolean softwareRenderingDisabled = Debug.isPropertyDefined("jogl.gljpanel.nosw", true);
    private boolean oglPipelineEnabled = Java2D.isOGLPipelineActive() && !Debug.isPropertyDefined("jogl.gljpanel.noogl", true);
    private int reshapeWidth;
    private int reshapeHeight;
    private int viewportX;
    private int viewportY;
    private AWTWindowClosingProtocol awtWindowClosingProtocol = new AWTWindowClosingProtocol(this, new Runnable(){

        @Override
        public void run() {
            GLJPanel.this.destroy();
        }
    });
    private final Runnable postDisposeAction = new Runnable(){

        @Override
        public void run() {
            if (GLJPanel.this.backend != null && !GLJPanel.this.backend.isUsingOwnThreadManagment()) {
                GLJPanel.this.backend.destroy();
                GLJPanel.this.backend = null;
                GLJPanel.this.isInitialized = false;
            }
        }
    };
    private final Runnable disposeAction = new Runnable(){

        @Override
        public void run() {
            GLJPanel.this.helper.disposeGL(GLJPanel.this, GLJPanel.this.backend.getDrawable(), GLJPanel.this.backend.getContext(), GLJPanel.this.postDisposeAction);
        }
    };
    private final Runnable updaterInitAction = new Runnable(){

        @Override
        public void run() {
            GLJPanel.this.updater.init(GLJPanel.this);
        }
    };
    private final Runnable updaterDisplayAction = new Runnable(){

        @Override
        public void run() {
            GLJPanel.this.updater.display(GLJPanel.this);
        }
    };
    private final Runnable paintImmediatelyAction = new Runnable(){

        @Override
        public void run() {
            GLJPanel.this.paintImmediately(0, 0, GLJPanel.this.getWidth(), GLJPanel.this.getHeight());
        }
    };

    public GLJPanel() throws GLException {
        this((GLCapabilitiesImmutable)null);
    }

    public GLJPanel(GLCapabilitiesImmutable gLCapabilitiesImmutable) throws GLException {
        this(gLCapabilitiesImmutable, null, null);
    }

    public GLJPanel(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) throws GLException {
        GLCapabilities gLCapabilities = gLCapabilitiesImmutable != null ? (GLCapabilities)gLCapabilitiesImmutable.cloneMutable() : new GLCapabilities(GLProfile.getDefault(GLProfile.getDefaultDevice()));
        gLCapabilities.setDoubleBuffered(false);
        this.offscreenCaps = gLCapabilities;
        this.glProfile = this.offscreenCaps.getGLProfile();
        this.factory = GLDrawableFactoryImpl.getFactoryImpl(this.glProfile);
        this.chooser = gLCapabilitiesChooser != null ? gLCapabilitiesChooser : new DefaultGLCapabilitiesChooser();
        this.shareWith = gLContext;
    }

    @Override
    public final Object getUpstreamWidget() {
        return this;
    }

    @Override
    public void display() {
        if (EventQueue.isDispatchThread()) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        } else {
            try {
                EventQueue.invokeAndWait(this.paintImmediatelyAction);
            }
            catch (Exception exception) {
                throw new GLException(exception);
            }
        }
    }

    protected void dispose() {
        if (DEBUG) {
            System.err.println(GLJPanel.getThreadName() + ": GLJPanel.dispose() - start");
        }
        if (this.backend != null && this.backend.getContext() != null) {
            boolean bl = false;
            GLAnimatorControl gLAnimatorControl = this.getAnimator();
            if (null != gLAnimatorControl) {
                bl = gLAnimatorControl.pause();
            }
            if (this.backend.getContext().isCreated()) {
                Threading.invoke(true, this.disposeAction, this.getTreeLock());
            }
            if (null != this.backend) {
                this.backend.destroy();
                this.isInitialized = false;
            }
            if (bl) {
                gLAnimatorControl.resume();
            }
        }
        if (DEBUG) {
            System.err.println(GLJPanel.getThreadName() + ": GLJPanel.dispose() - stop");
        }
    }

    @Override
    public void destroy() {
        this.removeNotify();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (Beans.isDesignTime()) {
            int n;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getName();
            if (string == null && (n = (string = this.getClass().getName()).lastIndexOf(46)) >= 0) {
                string = string.substring(n + 1);
            }
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() + rectangle2D.getHeight()) / 2.0));
            return;
        }
        if (this.backend == null || !this.isInitialized) {
            this.createAndInitializeBackend();
        }
        if (!this.isInitialized) {
            return;
        }
        if (this.handleReshape) {
            this.handleReshape();
        }
        this.updater.setGraphics(graphics);
        this.backend.doPaintComponent(graphics);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (DEBUG) {
            System.err.println(GLJPanel.getThreadName() + ": GLJPanel.addNotify()");
        }
    }

    @Override
    public void removeNotify() {
        this.awtWindowClosingProtocol.removeClosingListener();
        this.dispose();
        super.removeNotify();
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.reshapeWidth = n3;
        this.reshapeHeight = n4;
        this.handleReshape = true;
    }

    @Override
    public void setOpaque(boolean bl) {
        if (this.backend != null) {
            this.backend.setOpaque(bl);
        }
        super.setOpaque(bl);
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        this.helper.addGLEventListener(gLEventListener);
    }

    @Override
    public void addGLEventListener(int n, GLEventListener gLEventListener) {
        this.helper.addGLEventListener(n, gLEventListener);
    }

    @Override
    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.helper.removeGLEventListener(gLEventListener);
    }

    @Override
    public GLEventListener removeGLEventListener(int n) throws IndexOutOfBoundsException {
        return this.helper.removeGLEventListener(n);
    }

    @Override
    public void setAnimator(GLAnimatorControl gLAnimatorControl) {
        this.helper.setAnimator(gLAnimatorControl);
    }

    @Override
    public GLAnimatorControl getAnimator() {
        return this.helper.getAnimator();
    }

    @Override
    public boolean invoke(boolean bl, GLRunnable gLRunnable) {
        return this.helper.invoke(this, bl, gLRunnable);
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return null != this.backend ? this.backend.createContext(gLContext) : null;
    }

    @Override
    public void setRealized(boolean bl) {
    }

    @Override
    public boolean isRealized() {
        return this.isInitialized;
    }

    @Override
    public GLContext setContext(GLContext gLContext) {
        if (this.backend == null) {
            return null;
        }
        GLContext gLContext2 = this.backend.getContext();
        boolean bl = this.helper.switchContext(this.backend.getDrawable(), gLContext2, gLContext, this.additionalCtxCreationFlags);
        this.backend.setContext(gLContext);
        if (bl) {
            gLContext.makeCurrent();
        }
        return gLContext2;
    }

    @Override
    public GLContext getContext() {
        if (this.backend == null) {
            return null;
        }
        return this.backend.getContext();
    }

    @Override
    public GL getGL() {
        if (Beans.isDesignTime()) {
            return null;
        }
        GLContext gLContext = this.getContext();
        return gLContext == null ? null : gLContext.getGL();
    }

    @Override
    public GL setGL(GL gL) {
        GLContext gLContext = this.getContext();
        if (gLContext != null) {
            gLContext.setGL(gL);
            return gL;
        }
        return null;
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return true;
    }

    @Override
    public void swapBuffers() {
    }

    @Override
    public void setContextCreationFlags(int n) {
        this.additionalCtxCreationFlags = n;
    }

    @Override
    public int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    public boolean shouldPreserveColorBufferIfTranslucent() {
        return this.oglPipelineEnabled;
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        return this.backend.getChosenGLCapabilities();
    }

    @Override
    public final GLProfile getGLProfile() {
        return this.glProfile;
    }

    @Override
    public NativeSurface getNativeSurface() {
        throw new GLException("FIXME");
    }

    @Override
    public long getHandle() {
        throw new GLException("FIXME");
    }

    @Override
    public final GLDrawableFactory getFactory() {
        return this.factory;
    }

    private void createAndInitializeBackend() {
        if (this.panelWidth == 0 || this.panelHeight == 0) {
            if (this.reshapeWidth == 0 || this.reshapeHeight == 0) {
                return;
            }
            this.panelWidth = this.reshapeWidth;
            this.panelHeight = this.reshapeHeight;
        }
        do {
            if (this.backend == null) {
                if (this.oglPipelineEnabled) {
                    this.backend = new J2DOGLBackend();
                } else if (!hardwareAccelerationDisabled && this.factory.canCreateGLPbuffer(null)) {
                    this.backend = new PbufferBackend();
                } else {
                    if (softwareRenderingDisabled) {
                        throw new GLException("Fallback to software rendering disabled by user");
                    }
                    this.backend = new SoftwareBackend();
                }
            }
            if (this.isInitialized) continue;
            this.backend.initialize();
        } while (this.backend == null);
        this.awtWindowClosingProtocol.addClosingListenerOneShot();
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        return this.awtWindowClosingProtocol.getDefaultCloseOperation();
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        return this.awtWindowClosingProtocol.setDefaultCloseOperation(windowClosingMode);
    }

    private void handleReshape() {
        this.panelWidth = this.reshapeWidth;
        this.panelHeight = this.reshapeHeight;
        if (DEBUG) {
            System.err.println(GLJPanel.getThreadName() + ": GLJPanel.handleReshape: (w,h) = (" + this.panelWidth + "," + this.panelHeight + ")");
        }
        this.sendReshape = true;
        this.backend.handleReshape();
        this.handleReshape = false;
    }

    @Override
    public String toString() {
        return "AWT-GLJPanel[ " + (null != this.backend ? this.backend.getDrawable().getClass().getName() : "null-drawable") + "]";
    }

    private int getNextPowerOf2(int n) {
        if (n == 0) {
            return 2;
        }
        return GLBuffers.getNextPowerOf2(n);
    }

    private int getGLInteger(GL gL, int n) {
        int[] nArray = new int[1];
        gL.glGetIntegerv(n, nArray, 0);
        return nArray[0];
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    static {
        if (Java2D.isOGLPipelineActive() && Java2D.isFBOEnabled()) {
            Java2D.getShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
        }
    }

    class J2DOGLBackend
    implements Backend {
        private Object j2dSurface;
        private GLContext j2dContext;
        private GLDrawable joglDrawable;
        private GLContext joglContext;
        private int[] drawBuffer = new int[1];
        private int[] readBuffer = new int[1];
        private int[] frameBuffer = new int[1];
        private boolean checkedForFBObjectWorkarounds;
        private boolean fbObjectWorkarounds;
        private int[] frameBufferDepthBuffer;
        private int[] frameBufferTexture;
        private boolean createNewDepthBuffer;
        private boolean checkedGLVendor;
        private boolean vendorIsATI;
        private GraphicsConfiguration workaroundConfig;

        J2DOGLBackend() {
        }

        @Override
        public boolean isUsingOwnThreadManagment() {
            return true;
        }

        @Override
        public void initialize() {
            if (DEBUG) {
                System.err.println(GLJPanel.getThreadName() + ": J2DOGL: initialize()");
            }
            GLJPanel.this.isInitialized = true;
        }

        @Override
        public void destroy() {
            Java2D.invokeWithOGLContextCurrent(null, new Runnable(){

                @Override
                public void run() {
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": J2DOGL: destroy() - joglContext: " + (null != J2DOGLBackend.this.joglContext) + " - joglDrawable: " + (null != J2DOGLBackend.this.joglDrawable));
                    }
                    if (J2DOGLBackend.this.joglContext != null) {
                        J2DOGLBackend.this.joglContext.destroy();
                        J2DOGLBackend.this.joglContext = null;
                    }
                    J2DOGLBackend.this.joglDrawable = null;
                    if (J2DOGLBackend.this.j2dContext != null) {
                        J2DOGLBackend.this.j2dContext.destroy();
                        J2DOGLBackend.this.j2dContext = null;
                    }
                }
            });
        }

        @Override
        public void setOpaque(boolean bl) {
        }

        @Override
        public GLContext createContext(GLContext gLContext) {
            if (null != gLContext) {
                throw new GLException("J2DOGLBackend cannot create context w/ additional shared context, since it already needs to share the context w/ J2D.");
            }
            return null != this.joglDrawable && null != this.j2dContext ? this.joglDrawable.createContext(this.j2dContext) : null;
        }

        @Override
        public void setContext(GLContext gLContext) {
            this.joglContext = gLContext;
        }

        @Override
        public GLContext getContext() {
            return this.joglContext;
        }

        @Override
        public GLDrawable getDrawable() {
            return this.joglDrawable;
        }

        @Override
        public GLCapabilitiesImmutable getChosenGLCapabilities() {
            return new GLCapabilities(null);
        }

        @Override
        public GLProfile getGLProfile() {
            return GLProfile.getDefault(GLProfile.getDefaultDevice());
        }

        @Override
        public void handleReshape() {
        }

        @Override
        public boolean preGL(Graphics graphics) {
            GL2 gL2 = this.joglContext.getGL().getGL2();
            gL2.glEnable(3089);
            Rectangle rectangle = Java2D.getOGLScissorBox(graphics);
            if (rectangle == null) {
                if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": Java2D.getOGLScissorBox() returned null");
                }
                return false;
            }
            if (DEBUG) {
                System.err.println(GLJPanel.getThreadName() + ": GLJPanel: gl.glScissor(" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + ")");
            }
            gL2.glScissor(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Rectangle rectangle2 = Java2D.getOGLViewport(graphics, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
            if (GLJPanel.this.viewportX != rectangle2.x || GLJPanel.this.viewportY != rectangle2.y) {
                GLJPanel.this.sendReshape = true;
                if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": Sending reshape because viewport changed");
                    System.err.println("  viewportX (" + GLJPanel.this.viewportX + ") ?= oglViewport.x (" + rectangle2.x + ")");
                    System.err.println("  viewportY (" + GLJPanel.this.viewportY + ") ?= oglViewport.y (" + rectangle2.y + ")");
                }
            }
            GLJPanel.this.viewportX = rectangle2.x;
            GLJPanel.this.viewportY = rectangle2.y;
            if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
                int n;
                int n2 = Java2D.getOGLTextureType(graphics);
                if (!this.checkedForFBObjectWorkarounds) {
                    this.checkedForFBObjectWorkarounds = true;
                    gL2.glBindTexture(n2, 0);
                    gL2.glBindFramebuffer(36160, this.frameBuffer[0]);
                    n = gL2.glCheckFramebufferStatus(36160);
                    if (n != 36053) {
                        this.fbObjectWorkarounds = true;
                        this.createNewDepthBuffer = true;
                        if (DEBUG) {
                            System.err.println(GLJPanel.getThreadName() + ": GLJPanel: ERR GL_FRAMEBUFFER_BINDING: Discovered Invalid J2D FBO(" + this.frameBuffer[0] + "): " + FBObject.getStatusString(n) + ", frame_buffer_object workarounds to be necessary");
                        }
                    } else {
                        this.frameBufferTexture = null;
                        if (DEBUG) {
                            System.err.println(GLJPanel.getThreadName() + ": GLJPanel: OK GL_FRAMEBUFFER_BINDING: " + this.frameBuffer[0]);
                        }
                    }
                }
                if (this.fbObjectWorkarounds && this.createNewDepthBuffer) {
                    if (this.frameBufferDepthBuffer == null) {
                        this.frameBufferDepthBuffer = new int[1];
                    }
                    if (this.frameBufferDepthBuffer[0] != 0) {
                        gL2.glDeleteRenderbuffers(1, this.frameBufferDepthBuffer, 0);
                        this.frameBufferDepthBuffer[0] = 0;
                    }
                    gL2.glBindTexture(n2, this.frameBufferTexture[0]);
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    gL2.glGetTexLevelParameteriv(n2, 0, 4096, nArray, 0);
                    gL2.glGetTexLevelParameteriv(n2, 0, 4097, nArray2, 0);
                    gL2.glGenRenderbuffers(1, this.frameBufferDepthBuffer, 0);
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel: Generated frameBufferDepthBuffer " + this.frameBufferDepthBuffer[0] + " with width " + nArray[0] + ", height " + nArray2[0]);
                    }
                    gL2.glBindRenderbuffer(36161, this.frameBufferDepthBuffer[0]);
                    gL2.glRenderbufferStorage(36161, 33190, nArray[0], nArray2[0]);
                    gL2.glBindRenderbuffer(36161, 0);
                    this.createNewDepthBuffer = false;
                }
                gL2.glBindTexture(n2, 0);
                gL2.glBindFramebuffer(36160, this.frameBuffer[0]);
                if (this.fbObjectWorkarounds) {
                    gL2.glFramebufferTexture2D(36160, 36064, n2, this.frameBufferTexture[0], 0);
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel: frameBufferDepthBuffer: " + this.frameBufferDepthBuffer[0]);
                    }
                    gL2.glFramebufferRenderbuffer(36160, 36096, 36161, this.frameBufferDepthBuffer[0]);
                }
                if (DEBUG && (n = gL2.glCheckFramebufferStatus(36160)) != 36053) {
                    throw new GLException("Error: framebuffer was incomplete: status = 0x" + Integer.toHexString(n));
                }
            } else {
                if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": GLJPanel: Setting up drawBuffer " + this.drawBuffer[0] + " and readBuffer " + this.readBuffer[0]);
                }
                gL2.glDrawBuffer(this.drawBuffer[0]);
                gL2.glReadBuffer(this.readBuffer[0]);
            }
            return true;
        }

        @Override
        public void postGL(Graphics graphics, boolean bl) {
            GL gL = GLJPanel.this.getGL();
            gL.glFinish();
            if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
                gL.glBindFramebuffer(36160, 0);
            }
        }

        @Override
        public void doPaintComponent(final Graphics graphics) {
            if (Java2D.isFBOEnabled()) {
                if (this.workaroundConfig == null) {
                    this.workaroundConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                }
                Java2D.invokeWithOGLSharedContextCurrent(this.workaroundConfig, new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
            Java2D.invokeWithOGLContextCurrent(graphics, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel.invokeWithOGLContextCurrent");
                    }
                    if (J2DOGLBackend.this.j2dContext == null) {
                        J2DOGLBackend.this.j2dContext = GLJPanel.this.factory.createExternalGLContext();
                        if (DEBUG) {
                            System.err.println(GLJPanel.getThreadName() + ": GLJPanel.Created External Context: " + J2DOGLBackend.this.j2dContext);
                        }
                        if (DEBUG) {
                            // empty if block
                        }
                        J2DOGLBackend.this.j2dContext.makeCurrent();
                        object = J2DOGLBackend.this.j2dContext.getGL();
                        if (GLJPanel.this.getGLInteger((GL)object, 3410) < GLJPanel.this.offscreenCaps.getRedBits() || GLJPanel.this.getGLInteger((GL)object, 3411) < GLJPanel.this.offscreenCaps.getGreenBits() || GLJPanel.this.getGLInteger((GL)object, 3412) < GLJPanel.this.offscreenCaps.getBlueBits() || GLJPanel.this.getGLInteger((GL)object, 3416) < GLJPanel.this.offscreenCaps.getAccumRedBits() || GLJPanel.this.getGLInteger((GL)object, 3417) < GLJPanel.this.offscreenCaps.getAccumGreenBits() || GLJPanel.this.getGLInteger((GL)object, 3418) < GLJPanel.this.offscreenCaps.getAccumBlueBits() || GLJPanel.this.getGLInteger((GL)object, 3419) < GLJPanel.this.offscreenCaps.getAccumAlphaBits() || GLJPanel.this.getGLInteger((GL)object, 3415) < GLJPanel.this.offscreenCaps.getStencilBits()) {
                            if (DEBUG) {
                                System.err.println(GLJPanel.getThreadName() + ": GLJPanel: Falling back to pbuffer-based support because Java2D context insufficient");
                                System.err.println("                    Available              Required");
                                System.err.println("GL_RED_BITS         " + GLJPanel.this.getGLInteger((GL)object, 3410) + "              " + GLJPanel.this.offscreenCaps.getRedBits());
                                System.err.println("GL_GREEN_BITS       " + GLJPanel.this.getGLInteger((GL)object, 3411) + "              " + GLJPanel.this.offscreenCaps.getGreenBits());
                                System.err.println("GL_BLUE_BITS        " + GLJPanel.this.getGLInteger((GL)object, 3412) + "              " + GLJPanel.this.offscreenCaps.getBlueBits());
                                System.err.println("GL_ALPHA_BITS       " + GLJPanel.this.getGLInteger((GL)object, 3413) + "              " + GLJPanel.this.offscreenCaps.getAlphaBits());
                                System.err.println("GL_ACCUM_RED_BITS   " + GLJPanel.this.getGLInteger((GL)object, 3416) + "              " + GLJPanel.this.offscreenCaps.getAccumRedBits());
                                System.err.println("GL_ACCUM_GREEN_BITS " + GLJPanel.this.getGLInteger((GL)object, 3417) + "              " + GLJPanel.this.offscreenCaps.getAccumGreenBits());
                                System.err.println("GL_ACCUM_BLUE_BITS  " + GLJPanel.this.getGLInteger((GL)object, 3418) + "              " + GLJPanel.this.offscreenCaps.getAccumBlueBits());
                                System.err.println("GL_ACCUM_ALPHA_BITS " + GLJPanel.this.getGLInteger((GL)object, 3419) + "              " + GLJPanel.this.offscreenCaps.getAccumAlphaBits());
                                System.err.println("GL_DEPTH_BITS       " + GLJPanel.this.getGLInteger((GL)object, 3414) + "              " + GLJPanel.this.offscreenCaps.getDepthBits());
                                System.err.println("GL_STENCIL_BITS     " + GLJPanel.this.getGLInteger((GL)object, 3415) + "              " + GLJPanel.this.offscreenCaps.getStencilBits());
                            }
                            GLJPanel.this.isInitialized = false;
                            GLJPanel.this.backend = null;
                            GLJPanel.this.oglPipelineEnabled = false;
                            GLJPanel.this.handleReshape = true;
                            J2DOGLBackend.this.j2dContext.destroy();
                            J2DOGLBackend.this.j2dContext = null;
                            return;
                        }
                    } else {
                        J2DOGLBackend.this.j2dContext.makeCurrent();
                    }
                    try {
                        J2DOGLBackend.this.captureJ2DState(J2DOGLBackend.this.j2dContext.getGL(), graphics);
                        object = Java2D.getOGLSurfaceIdentifier(graphics);
                        if (object != null) {
                            if (J2DOGLBackend.this.j2dSurface != object) {
                                if (J2DOGLBackend.this.joglContext != null) {
                                    J2DOGLBackend.this.joglContext.destroy();
                                    J2DOGLBackend.this.joglContext = null;
                                    J2DOGLBackend.this.joglDrawable = null;
                                    GLJPanel.this.sendReshape = true;
                                    if (DEBUG) {
                                        System.err.println(GLJPanel.getThreadName() + ": Sending reshape because surface changed");
                                        System.err.println("New surface = " + object);
                                    }
                                }
                                J2DOGLBackend.this.j2dSurface = object;
                                if (DEBUG) {
                                    System.err.print(GLJPanel.getThreadName() + ": Surface type: ");
                                    int n = Java2D.getOGLSurfaceType(graphics);
                                    if (n == Java2D.UNDEFINED) {
                                        System.err.println("UNDEFINED");
                                    } else if (n == Java2D.WINDOW) {
                                        System.err.println("WINDOW");
                                    } else if (n == Java2D.PBUFFER) {
                                        System.err.println("PBUFFER");
                                    } else if (n == Java2D.TEXTURE) {
                                        System.err.println("TEXTURE");
                                    } else if (n == Java2D.FLIP_BACKBUFFER) {
                                        System.err.println("FLIP_BACKBUFFER");
                                    } else if (n == Java2D.FBOBJECT) {
                                        System.err.println("FBOBJECT");
                                    } else {
                                        System.err.println("(Unknown surface type " + n + ")");
                                    }
                                }
                            }
                            if (J2DOGLBackend.this.joglContext == null) {
                                AbstractGraphicsDevice abstractGraphicsDevice = J2DOGLBackend.this.j2dContext.getGLDrawable().getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
                                if (GLJPanel.this.factory.canCreateExternalGLDrawable(abstractGraphicsDevice)) {
                                    J2DOGLBackend.this.joglDrawable = GLJPanel.this.factory.createExternalGLDrawable();
                                    J2DOGLBackend.this.joglContext = J2DOGLBackend.this.joglDrawable.createContext(J2DOGLBackend.this.j2dContext);
                                    if (DEBUG) {
                                        System.err.println("-- Created External Drawable: " + J2DOGLBackend.this.joglDrawable);
                                        System.err.println("-- Created Context: " + J2DOGLBackend.this.joglContext);
                                    }
                                } else if (GLJPanel.this.factory.canCreateContextOnJava2DSurface(abstractGraphicsDevice)) {
                                    J2DOGLBackend.this.joglContext = GLJPanel.this.factory.createContextOnJava2DSurface(graphics, J2DOGLBackend.this.j2dContext);
                                    if (DEBUG) {
                                        System.err.println("-- Created Context: " + J2DOGLBackend.this.joglContext);
                                    }
                                }
                                if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT && J2DOGLBackend.this.fbObjectWorkarounds) {
                                    J2DOGLBackend.this.createNewDepthBuffer = true;
                                }
                            }
                            if (J2DOGLBackend.this.joglContext instanceof Java2DGLContext) {
                                ((Java2DGLContext)((Object)J2DOGLBackend.this.joglContext)).setGraphics(graphics);
                            }
                            GLJPanel.this.helper.invokeGL(J2DOGLBackend.this.joglDrawable, J2DOGLBackend.this.joglContext, GLJPanel.this.updaterDisplayAction, GLJPanel.this.updaterInitAction);
                        }
                    }
                    finally {
                        J2DOGLBackend.this.j2dContext.release();
                    }
                }
            });
        }

        private void captureJ2DState(GL gL, Graphics graphics) {
            gL.glGetIntegerv(3073, this.drawBuffer, 0);
            gL.glGetIntegerv(3074, this.readBuffer, 0);
            if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
                gL.glGetIntegerv(36006, this.frameBuffer, 0);
                if (!gL.glIsFramebuffer(this.frameBuffer[0])) {
                    this.checkedForFBObjectWorkarounds = true;
                    this.fbObjectWorkarounds = true;
                    this.createNewDepthBuffer = true;
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel: Fetched ERR GL_FRAMEBUFFER_BINDING: " + this.frameBuffer[0] + " - NOT A FBO" + ", frame_buffer_object workarounds to be necessary");
                    }
                } else if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": GLJPanel: Fetched OK GL_FRAMEBUFFER_BINDING: " + this.frameBuffer[0]);
                }
                if (this.fbObjectWorkarounds || !this.checkedForFBObjectWorkarounds) {
                    if (this.frameBufferTexture == null) {
                        this.frameBufferTexture = new int[1];
                    }
                    gL.glGetFramebufferAttachmentParameteriv(36160, 36064, 36049, this.frameBufferTexture, 0);
                    if (DEBUG) {
                        System.err.println(GLJPanel.getThreadName() + ": GLJPanel: FBO COLOR_ATTACHMENT0: " + this.frameBufferTexture[0]);
                    }
                }
                if (!this.checkedGLVendor) {
                    this.checkedGLVendor = true;
                    String string = gL.glGetString(7936);
                    if (string != null && string.startsWith("ATI")) {
                        this.vendorIsATI = true;
                    }
                }
                if (this.vendorIsATI) {
                    gL.glBindFramebuffer(36160, 0);
                }
            }
        }
    }

    class PbufferBackend
    extends AbstractReadbackBackend {
        private GLPbuffer pbuffer;
        private int pbufferWidth;
        private int pbufferHeight;

        PbufferBackend() {
            this.pbufferWidth = 256;
            this.pbufferHeight = 256;
        }

        @Override
        public boolean isUsingOwnThreadManagment() {
            return false;
        }

        @Override
        public void initialize() {
            if (this.pbuffer != null) {
                throw new InternalError("Creating pbuffer twice without destroying it (memory leak / correctness bug)");
            }
            if (DEBUG) {
                System.err.println(GLJPanel.getThreadName() + ": PbufferBackend: initialize()");
            }
            try {
                this.pbuffer = GLJPanel.this.factory.createGLPbuffer(null, GLJPanel.this.offscreenCaps, null, this.pbufferWidth, this.pbufferHeight, GLJPanel.this.shareWith);
                this.pbuffer.setContextCreationFlags(GLJPanel.this.additionalCtxCreationFlags);
                this.pbuffer.addGLEventListener(GLJPanel.this.updater);
                GLJPanel.this.isInitialized = true;
            }
            catch (GLException gLException) {
                if (DEBUG) {
                    gLException.printStackTrace();
                    System.err.println(GLJPanel.getThreadName() + ": GLJPanel: Falling back on software rendering because of problems creating pbuffer");
                }
                hardwareAccelerationDisabled = true;
                GLJPanel.this.backend = null;
                GLJPanel.this.isInitialized = false;
                GLJPanel.this.createAndInitializeBackend();
            }
        }

        @Override
        public void destroy() {
            if (DEBUG) {
                System.err.println(GLJPanel.getThreadName() + ": PbufferBackend: destroy() - pbuffer: " + (null != this.pbuffer));
            }
            if (this.pbuffer != null) {
                this.pbuffer.destroy();
                this.pbuffer = null;
            }
        }

        @Override
        public GLContext createContext(GLContext gLContext) {
            return null != this.pbuffer ? this.pbuffer.createContext(gLContext) : null;
        }

        @Override
        public void setContext(GLContext gLContext) {
            if (this.pbuffer == null || Beans.isDesignTime()) {
                return;
            }
            this.pbuffer.setContext(gLContext);
        }

        @Override
        public GLContext getContext() {
            if (null == this.pbuffer || Beans.isDesignTime()) {
                return null;
            }
            return this.pbuffer.getContext();
        }

        @Override
        public GLDrawable getDrawable() {
            return this.pbuffer;
        }

        @Override
        public GLCapabilitiesImmutable getChosenGLCapabilities() {
            if (this.pbuffer == null) {
                return null;
            }
            return this.pbuffer.getChosenGLCapabilities();
        }

        @Override
        public GLProfile getGLProfile() {
            if (this.pbuffer == null) {
                return null;
            }
            return this.pbuffer.getGLProfile();
        }

        @Override
        public void handleReshape() {
            float f = 2.5f;
            if (GLJPanel.this.panelWidth > this.pbufferWidth || GLJPanel.this.panelHeight > this.pbufferHeight || (float)GLJPanel.this.panelWidth < (float)this.pbufferWidth / f || (float)GLJPanel.this.panelHeight < (float)this.pbufferHeight / f) {
                if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": Resizing pbuffer from (" + this.pbufferWidth + ", " + this.pbufferHeight + ") " + " to fit (" + GLJPanel.this.panelWidth + ", " + GLJPanel.this.panelHeight + ")");
                }
                if (this.pbuffer != null) {
                    try {
                        this.pbuffer.destroy();
                    }
                    catch (GLException gLException) {
                        hardwareAccelerationDisabled = true;
                        GLJPanel.this.backend = null;
                        GLJPanel.this.isInitialized = false;
                        this.readBackWidthInPixels = Math.max(1, GLJPanel.this.panelWidth);
                        this.readBackHeightInPixels = Math.max(1, GLJPanel.this.panelHeight);
                        if (DEBUG) {
                            System.err.println(GLJPanel.getThreadName() + ": Warning: falling back to software rendering due to bugs in OpenGL drivers");
                            gLException.printStackTrace();
                        }
                        GLJPanel.this.createAndInitializeBackend();
                        return;
                    }
                }
                this.pbuffer = null;
                GLJPanel.this.isInitialized = false;
                this.pbufferWidth = GLJPanel.this.getNextPowerOf2(GLJPanel.this.panelWidth);
                this.pbufferHeight = GLJPanel.this.getNextPowerOf2(GLJPanel.this.panelHeight);
                if (DEBUG && !hardwareAccelerationDisabled) {
                    System.err.println(GLJPanel.getThreadName() + ": New pbuffer size is (" + this.pbufferWidth + ", " + this.pbufferHeight + ")");
                }
                this.initialize();
            }
            this.readBackWidthInPixels = this.pbufferWidth;
            this.readBackHeightInPixels = GLJPanel.this.panelHeight;
            if (this.offscreenImage != null) {
                this.offscreenImage.flush();
                this.offscreenImage = null;
            }
        }

        @Override
        protected void doPaintComponentImpl() {
            this.pbuffer.display();
        }

        @Override
        protected int getGLPixelType() {
            return 33639;
        }

        @Override
        protected boolean flipVertically() {
            return true;
        }
    }

    class SoftwareBackend
    extends AbstractReadbackBackend {
        private GLDrawableImpl offscreenDrawable;
        private GLContextImpl offscreenContext;

        SoftwareBackend() {
        }

        @Override
        public boolean isUsingOwnThreadManagment() {
            return false;
        }

        @Override
        public void initialize() {
            if (DEBUG) {
                System.err.println(GLJPanel.getThreadName() + ": SoftwareBackend: initialize()");
            }
            this.offscreenDrawable = (GLDrawableImpl)GLJPanel.this.factory.createOffscreenDrawable(null, GLJPanel.this.offscreenCaps, GLJPanel.this.chooser, Math.max(1, GLJPanel.this.panelWidth), Math.max(1, GLJPanel.this.panelHeight));
            this.offscreenDrawable.setRealized(true);
            this.offscreenContext = (GLContextImpl)this.offscreenDrawable.createContext(GLJPanel.this.shareWith);
            this.offscreenContext.setContextCreationFlags(GLJPanel.this.additionalCtxCreationFlags);
            GLJPanel.this.isInitialized = true;
        }

        @Override
        public void destroy() {
            if (DEBUG) {
                System.err.println(GLJPanel.getThreadName() + ": SoftwareBackend: destroy() - offscreenContext: " + (null != this.offscreenContext) + " - offscreenDrawable: " + (null != this.offscreenDrawable));
            }
            if (this.offscreenContext != null) {
                this.offscreenContext.destroy();
                this.offscreenContext = null;
            }
            if (this.offscreenDrawable != null) {
                AbstractGraphicsDevice abstractGraphicsDevice = this.offscreenDrawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
                this.offscreenDrawable.setRealized(false);
                this.offscreenDrawable = null;
                if (null != abstractGraphicsDevice) {
                    abstractGraphicsDevice.close();
                }
            }
        }

        @Override
        public GLContext createContext(GLContext gLContext) {
            return null != this.offscreenDrawable ? this.offscreenDrawable.createContext(gLContext) : null;
        }

        @Override
        public void setContext(GLContext gLContext) {
            this.offscreenContext = (GLContextImpl)gLContext;
        }

        @Override
        public GLContext getContext() {
            return this.offscreenContext;
        }

        @Override
        public GLDrawable getDrawable() {
            return this.offscreenDrawable;
        }

        @Override
        public GLCapabilitiesImmutable getChosenGLCapabilities() {
            if (this.offscreenDrawable == null) {
                return null;
            }
            return this.offscreenDrawable.getChosenGLCapabilities();
        }

        @Override
        public GLProfile getGLProfile() {
            if (this.offscreenDrawable == null) {
                return null;
            }
            return this.offscreenDrawable.getGLProfile();
        }

        @Override
        public void handleReshape() {
            this.destroy();
            this.initialize();
            this.readBackWidthInPixels = Math.max(1, GLJPanel.this.panelWidth);
            this.readBackHeightInPixels = Math.max(1, GLJPanel.this.panelHeight);
            if (this.offscreenImage != null) {
                this.offscreenImage.flush();
                this.offscreenImage = null;
            }
        }

        @Override
        protected void doPaintComponentImpl() {
            GLJPanel.this.helper.invokeGL(this.offscreenDrawable, this.offscreenContext, GLJPanel.this.updaterDisplayAction, GLJPanel.this.updaterInitAction);
        }

        @Override
        protected int getGLPixelType() {
            return this.offscreenContext.getOffscreenContextPixelDataType();
        }

        @Override
        protected boolean flipVertically() {
            return this.offscreenContext.offscreenImageNeedsVerticalFlip();
        }
    }

    abstract class AbstractReadbackBackend
    implements Backend {
        protected BufferedImage offscreenImage;
        protected ByteBuffer readBackBytes;
        protected IntBuffer readBackInts;
        protected int readBackWidthInPixels;
        protected int readBackHeightInPixels;
        private int glFormat;
        private int glType;
        private int[] swapbytes = new int[1];
        private int[] rowlength = new int[1];
        private int[] skiprows = new int[1];
        private int[] skippixels = new int[1];
        private int[] alignment = new int[1];

        AbstractReadbackBackend() {
        }

        @Override
        public void setOpaque(boolean bl) {
            if (bl != GLJPanel.this.isOpaque() && this.offscreenImage != null) {
                this.offscreenImage.flush();
                this.offscreenImage = null;
            }
        }

        @Override
        public boolean preGL(Graphics graphics) {
            return true;
        }

        @Override
        public void postGL(Graphics graphics, boolean bl) {
            block16: {
                if (!bl) break block16;
                if (this.offscreenImage == null && GLJPanel.this.panelWidth > 0 && GLJPanel.this.panelHeight > 0) {
                    int n = 0;
                    n = GLJPanel.this.isOpaque() ? 1 : 2;
                    this.offscreenImage = new BufferedImage(GLJPanel.this.panelWidth, GLJPanel.this.panelHeight, n);
                    switch (n) {
                        case 5: {
                            this.glFormat = 32992;
                            this.glType = 5121;
                            this.readBackBytes = ByteBuffer.allocate(this.readBackWidthInPixels * this.readBackHeightInPixels * 3);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.glFormat = 32993;
                            this.glType = this.getGLPixelType();
                            this.readBackInts = IntBuffer.allocate(this.readBackWidthInPixels * this.readBackHeightInPixels);
                            break;
                        }
                        default: {
                            throw new GLException("Unsupported offscreen image type " + n);
                        }
                    }
                }
                if (this.offscreenImage != null) {
                    GL2 gL2 = GLJPanel.this.getGL().getGL2();
                    gL2.glGetIntegerv(3328, this.swapbytes, 0);
                    gL2.glGetIntegerv(3330, this.rowlength, 0);
                    gL2.glGetIntegerv(3331, this.skiprows, 0);
                    gL2.glGetIntegerv(3332, this.skippixels, 0);
                    gL2.glGetIntegerv(3333, this.alignment, 0);
                    gL2.glPixelStorei(3328, 0);
                    gL2.glPixelStorei(3330, this.readBackWidthInPixels);
                    gL2.glPixelStorei(3331, 0);
                    gL2.glPixelStorei(3332, 0);
                    gL2.glPixelStorei(3333, 1);
                    gL2.glReadBuffer(1028);
                    if (this.readBackBytes != null) {
                        gL2.glReadPixels(0, 0, this.readBackWidthInPixels, this.readBackHeightInPixels, this.glFormat, this.glType, this.readBackBytes);
                    } else if (this.readBackInts != null) {
                        gL2.glReadPixels(0, 0, this.readBackWidthInPixels, this.readBackHeightInPixels, this.glFormat, this.glType, this.readBackInts);
                    }
                    gL2.glPixelStorei(3328, this.swapbytes[0]);
                    gL2.glPixelStorei(3330, this.rowlength[0]);
                    gL2.glPixelStorei(3331, this.skiprows[0]);
                    gL2.glPixelStorei(3332, this.skippixels[0]);
                    gL2.glPixelStorei(3333, this.alignment[0]);
                    if (this.readBackBytes != null || this.readBackInts != null) {
                        Object[] objectArray = null;
                        Object[] objectArray2 = null;
                        int n = 0;
                        int n2 = 0;
                        if (this.readBackBytes != null) {
                            objectArray = this.readBackBytes.array();
                            objectArray2 = ((DataBufferByte)this.offscreenImage.getRaster().getDataBuffer()).getData();
                            n = this.readBackWidthInPixels * 3;
                            n2 = this.offscreenImage.getWidth() * 3;
                        } else {
                            objectArray = this.readBackInts.array();
                            objectArray2 = ((DataBufferInt)this.offscreenImage.getRaster().getDataBuffer()).getData();
                            n = this.readBackWidthInPixels;
                            n2 = this.offscreenImage.getWidth();
                        }
                        if (this.flipVertically()) {
                            int n3 = 0;
                            for (int i = (this.offscreenImage.getHeight() - 1) * n2; i >= 0; i -= n2) {
                                System.arraycopy(objectArray, n3, objectArray2, i, n2);
                                n3 += n;
                            }
                        } else {
                            int n4 = 0;
                            int n5 = n2 * this.offscreenImage.getHeight();
                            for (int i = 0; i < n5; i += n2) {
                                System.arraycopy(objectArray, n4, objectArray2, i, n2);
                                n4 += n;
                            }
                        }
                    }
                }
            }
        }

        @Override
        public void doPaintComponent(Graphics graphics) {
            this.doPaintComponentImpl();
            if (this.offscreenImage != null) {
                graphics.drawImage(this.offscreenImage, 0, 0, this.offscreenImage.getWidth(), this.offscreenImage.getHeight(), GLJPanel.this);
            }
        }

        protected abstract void doPaintComponentImpl();

        protected abstract int getGLPixelType();

        protected abstract boolean flipVertically();
    }

    static interface Backend {
        public boolean isUsingOwnThreadManagment();

        public void initialize();

        public void destroy();

        public void setOpaque(boolean var1);

        public GLContext createContext(GLContext var1);

        public void setContext(GLContext var1);

        public GLContext getContext();

        public GLDrawable getDrawable();

        public GLCapabilitiesImmutable getChosenGLCapabilities();

        public GLProfile getGLProfile();

        public void handleReshape();

        public boolean preGL(Graphics var1);

        public void postGL(Graphics var1, boolean var2);

        public void doPaintComponent(Graphics var1);
    }

    class Updater
    implements GLEventListener {
        private Graphics g;

        Updater() {
        }

        public void setGraphics(Graphics graphics) {
            this.g = graphics;
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            if (!GLJPanel.this.backend.preGL(this.g)) {
                return;
            }
            GLJPanel.this.helper.init(GLJPanel.this);
            GLJPanel.this.backend.postGL(this.g, false);
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            GLJPanel.this.helper.dispose(GLJPanel.this);
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            if (!GLJPanel.this.backend.preGL(this.g)) {
                return;
            }
            if (GLJPanel.this.sendReshape) {
                if (DEBUG) {
                    System.err.println(GLJPanel.getThreadName() + ": GLJPanel.display: reshape(" + GLJPanel.this.viewportX + "," + GLJPanel.this.viewportY + " " + GLJPanel.this.panelWidth + "x" + GLJPanel.this.panelHeight + ")");
                }
                GLJPanel.this.helper.reshape(GLJPanel.this, GLJPanel.this.viewportX, GLJPanel.this.viewportY, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                GLJPanel.this.sendReshape = false;
            }
            GLJPanel.this.helper.display(GLJPanel.this);
            GLJPanel.this.backend.postGL(this.g, true);
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }
}

