/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.SurfaceUpdatedListener;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.SurfaceUpdatedHelper;

public abstract class ProxySurface
implements NativeSurface,
MutableSurface {
    public static final boolean DEBUG = Debug.debug("ProxySurface");
    public static final int OWN_DEVICE = 128;
    public static final int INVISIBLE_WINDOW = 256;
    private final SurfaceUpdatedHelper surfaceUpdatedHelper = new SurfaceUpdatedHelper();
    private final AbstractGraphicsConfiguration config;
    private final UpstreamSurfaceHook upstream;
    public final int initialWidth;
    public final int initialHeight;
    private long surfaceHandle_old;
    protected RecursiveLock surfaceLock = LockFactory.createRecursiveLock();
    protected long displayHandle;
    protected int scrnIndex;
    protected int implBitfield;

    protected ProxySurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration, int n, int n2, UpstreamSurfaceHook upstreamSurfaceHook) {
        if (null == abstractGraphicsConfiguration) {
            throw new IllegalArgumentException("null config");
        }
        this.config = abstractGraphicsConfiguration;
        this.upstream = upstreamSurfaceHook;
        this.initialWidth = n;
        this.initialHeight = n2;
        this.displayHandle = this.config.getNativeGraphicsConfiguration().getScreen().getDevice().getHandle();
        this.surfaceHandle_old = 0L;
        this.implBitfield = 0;
    }

    public final UpstreamSurfaceHook getUpstreamSurfaceHook() {
        return this.upstream;
    }

    public void createNotify() {
        if (null != this.upstream) {
            this.upstream.create(this);
        }
        this.displayHandle = this.config.getNativeGraphicsConfiguration().getScreen().getDevice().getHandle();
        this.surfaceHandle_old = 0L;
    }

    public void destroyNotify() {
        if (null != this.upstream) {
            this.upstream.destroy(this);
            this.invalidateImpl();
        }
        this.displayHandle = 0L;
        this.surfaceHandle_old = 0L;
    }

    protected void invalidateImpl() {
        throw new InternalError("UpstreamSurfaceHook given, but required method not implemented.");
    }

    @Override
    public final long getDisplayHandle() {
        return this.displayHandle;
    }

    protected final AbstractGraphicsConfiguration getPrivateGraphicsConfiguration() {
        return this.config;
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config.getNativeGraphicsConfiguration();
    }

    @Override
    public final int getScreenIndex() {
        return this.getGraphicsConfiguration().getScreen().getIndex();
    }

    @Override
    public abstract long getSurfaceHandle();

    @Override
    public abstract void setSurfaceHandle(long var1);

    @Override
    public final int getWidth() {
        if (null != this.upstream) {
            return this.upstream.getWidth(this);
        }
        return this.initialWidth;
    }

    @Override
    public final int getHeight() {
        if (null != this.upstream) {
            return this.upstream.getHeight(this);
        }
        return this.initialHeight;
    }

    @Override
    public boolean surfaceSwap() {
        return false;
    }

    @Override
    public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    @Override
    public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.surfaceUpdatedHelper.surfaceUpdated(object, nativeSurface, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lockSurface() throws NativeWindowException, RuntimeException {
        int n;
        this.surfaceLock.lock();
        int n2 = n = this.surfaceLock.getHoldCount() == 1 ? 1 : 3;
        if (1 == n) {
            try {
                AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
                abstractGraphicsDevice.lock();
                try {
                    n = this.lockSurfaceImpl();
                    if (3 == n && this.surfaceHandle_old != this.getSurfaceHandle()) {
                        n = 2;
                        if (DEBUG) {
                            System.err.println("ProxySurface: surface change 0x" + Long.toHexString(this.surfaceHandle_old) + " -> 0x" + Long.toHexString(this.getSurfaceHandle()));
                        }
                    }
                }
                finally {
                    if (1 >= n) {
                        abstractGraphicsDevice.unlock();
                    }
                }
            }
            finally {
                if (1 >= n) {
                    this.surfaceLock.unlock();
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlockSurface() {
        this.surfaceLock.validateLocked();
        this.surfaceHandle_old = this.getSurfaceHandle();
        if (this.surfaceLock.getHoldCount() == 1) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
            try {
                this.unlockSurfaceImpl();
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
        this.surfaceLock.unlock();
    }

    protected abstract int lockSurfaceImpl();

    protected abstract void unlockSurfaceImpl();

    public final void validateSurfaceLocked() {
        this.surfaceLock.validateLocked();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.surfaceLock.isLockedByOtherThread();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.surfaceLock.getOwner();
    }

    public abstract String toString();

    public int getImplBitfield() {
        return this.implBitfield;
    }

    public void setImplBitfield(int n) {
        this.implBitfield = n;
    }

    public static interface UpstreamSurfaceHook {
        public void create(ProxySurface var1);

        public void destroy(ProxySurface var1);

        public int getWidth(ProxySurface var1);

        public int getHeight(ProxySurface var1);
    }
}

