/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedPropertyUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.IntegerProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TeamScoreShared;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class TeamScoreSharedImpl
extends TeamScoreShared {
    protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap(2);
    protected UnrealId Id = null;
    protected IntegerProperty myTeam = null;
    protected IntegerProperty myScore = null;

    public TeamScoreSharedImpl(TeamScoreSharedImpl source) {
        this.Id = source.getId();
        this.myTeam = source.myTeam;
        this.myScore = source.myScore;
    }

    public TeamScoreSharedImpl(WorldObjectId objectId, Collection<ISharedProperty> properties) {
        this.Id = (UnrealId)objectId;
        NullCheck.check((Object)this.Id, (String)"objectId");
        if (properties.size() != 2) {
            throw new PogamutException("Not enough properties passed to the constructor.", TeamScoreSharedImpl.class);
        }
        for (ISharedProperty property : properties) {
            PropertyId pId = property.getPropertyId();
            if (!objectId.equals((Object)property.getObjectId())) {
                throw new PogamutException("Trying to create a TeamScoreSharedImpl with different WorldObjectId properties : " + this.Id.getStringId() + " / " + property.getObjectId().getStringId(), (Object)this);
            }
            if (!TeamScoreShared.SharedPropertyTokens.contains(pId.getPropertyToken())) {
                throw new PogamutException("Trying to create a TeamScoreSharedImpl with invalid property (invalid property token): " + this.Id.getStringId() + " / " + property.getPropertyId().getPropertyToken().getToken(), (Object)this);
            }
            this.propertyMap.put(property.getPropertyId(), property);
            if (pId.getPropertyToken().getToken().equals("Team")) {
                this.myTeam = (IntegerProperty)property;
            }
            if (!pId.getPropertyToken().getToken().equals("Score")) continue;
            this.myScore = (IntegerProperty)property;
        }
    }

    @Override
    public void setSimTime(long SimTime) {
        super.setSimTime(SimTime);
    }

    @Override
    public TeamScoreSharedImpl clone() {
        return new TeamScoreSharedImpl(this);
    }

    public ISharedProperty getProperty(PropertyId id) {
        return this.propertyMap.get(id);
    }

    public Map<PropertyId, ISharedProperty> getProperties() {
        return this.propertyMap;
    }

    @Override
    public UnrealId getId() {
        return this.Id;
    }

    @Override
    public Integer getTeam() {
        return (Integer)this.myTeam.getValue();
    }

    @Override
    public Integer getScore() {
        return (Integer)this.myScore.getValue();
    }

    @Override
    public String toString() {
        return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "Team = " + String.valueOf(this.getTeam()) + " | " + "Score = " + String.valueOf(this.getScore()) + " | " + "]";
    }

    @Override
    public String toHtmlString() {
        return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>Team</b> = " + String.valueOf(this.getTeam()) + " <br/> " + "<b>Score</b> = " + String.valueOf(this.getScore()) + " <br/> " + "<br/>]";
    }

    public static class TeamScoreSharedUpdate
    implements ISharedWorldObjectUpdatedEvent {
        private TeamScoreShared object;
        private long time;
        private ITeamId teamId;

        public TeamScoreSharedUpdate(TeamScoreShared data, long time, ITeamId teamId) {
            this.object = data;
            this.time = time;
            this.teamId = teamId;
        }

        public long getSimTime() {
            return this.time;
        }

        public WorldObjectId getId() {
            return this.object.getId();
        }

        public ITeamId getTeamId() {
            return this.teamId;
        }

        public Class getCompositeObjectClass() {
            return this.object.getCompositeClass();
        }

        public Collection<ISharedPropertyUpdatedEvent> getPropertyEvents() {
            LinkedList<ISharedPropertyUpdatedEvent> events = new LinkedList<ISharedPropertyUpdatedEvent>();
            for (ISharedProperty property : this.object.getProperties().values()) {
                if (property == null) continue;
                events.push(property.createUpdateEvent(this.time, this.teamId));
            }
            return events;
        }
    }
}

