/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.timeline.map;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealWaypoint;
import java.awt.Color;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.GlColor;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.ISubGLRenderer;

public class WaypointRenderer
implements ISubGLRenderer<IUnrealWaypoint> {
    public static final double NAVPOINT_OUTER_RADIUS = 30.0;
    public static final double NAVPOINT_INNER_RADIUS = 0.0;
    public static final int NAVPOINT_SLICES = 32;
    public static final int NAVPOINT_RINGS = 1;
    public static final double NAVPOINT_FLOAT = 1.0;
    private static final Color WAYPOINT_COLOR_DEFAULT = Color.BLUE;
    private static final String WAYPOINT_COLOR_KEY = "WAYPOINT_COLOR_KEY";
    private static final Preferences preferences = Preferences.userNodeForPackage(WaypointRenderer.class);
    private PreferenceChangeListener changeListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            WaypointRenderer.this.dirty = true;
        }
    };
    private final IUnrealWaypoint waypoint;
    private final int glName;
    private int displayList;
    private boolean dirty = false;

    public WaypointRenderer(IUnrealWaypoint waypoint, int glName) {
        this.waypoint = waypoint;
        this.glName = glName;
        preferences.addPreferenceChangeListener(this.changeListener);
    }

    @Override
    public void prepare(GL gl) {
    }

    @Override
    public void render(GL gla) {
        GL2 gl = gla.getGL2();
        try {
            if (this.dirty || !gl.glIsList(this.displayList)) {
                this.updateDisplayLists(gl);
                this.dirty = false;
            }
            gl.glLoadName(this.glName);
            gl.glCallList(this.displayList);
            gl.glLoadName(-1);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void updateDisplayLists(GL2 gl) {
        gl.glDeleteLists(this.displayList, 1);
        this.displayList = gl.glGenLists(1);
        gl.glNewList(this.displayList, 4864);
        this.renderWayPoint(gl);
        gl.glEndList();
    }

    private void renderWayPoint(GL2 gl) {
        GLU glu = new GLU();
        GLUquadric qaudric = glu.gluNewQuadric();
        GlColor color = new GlColor(WaypointRenderer.getColor());
        Location position = this.waypoint.getLocation();
        if (position == null) {
            return;
        }
        gl.glPushMatrix();
        gl.glTranslated(position.x, position.y, position.z + 1.0);
        gl.glColor4d(color.r, color.g, color.b, color.a);
        glu.gluDisk(qaudric, 0.0, 30.0, 32, 1);
        gl.glPopMatrix();
    }

    @Override
    public IUnrealWaypoint getObject() {
        return this.waypoint;
    }

    public static Color getColor() {
        int rgb = preferences.getInt(WAYPOINT_COLOR_KEY, WAYPOINT_COLOR_DEFAULT.getRGB());
        return new Color(rgb);
    }

    public static void setColor(Color c) {
        preferences.putInt(WAYPOINT_COLOR_KEY, c.getRGB());
    }

    @Override
    public int getGLName() {
        return this.glName;
    }

    @Override
    public void destroy() {
        preferences.removePreferenceChangeListener(this.changeListener);
    }
}

