/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.map;

import cz.cuni.amis.pogamut.unreal.communication.messages.gbinfomessages.IPlayer;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMap;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealWaypoint;
import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import java.util.Collection;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import nl.tudelft.goal.ut2004.visualizer.map.SelectableMapGLPanel;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.FlagRenderer;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.PlayerRenderer;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.WaypointRenderer;

public class PureMapGLPanel
extends SelectableMapGLPanel
implements CollectionEventListener<IPlayer> {
    protected IUnrealServer server;
    private Timer timer;
    private final int REDRAW_DELAY = 30;

    protected PureMapGLPanel(IUnrealMap map, IUnrealServer server) {
        super(map, Logger.getLogger("PureMapGLPanel"));
        this.server = server;
        for (Object agent : server.getPlayers()) {
            this.addAgentRenderer((IPlayer)agent);
        }
        Map flags = server.getWorldView().getAll(FlagInfo.class);
        for (FlagInfo flag : flags.values()) {
            this.addFlagRenderer(flag);
        }
        Collection navs = map.vertexSet();
        for (IUnrealWaypoint waypoint : navs) {
            this.addWaypointRenderer(waypoint);
        }
        server.getPlayers().addCollectionListener((CollectionEventListener)this);
    }

    public synchronized void startDisplayLoop() {
        if (this.timer == null) {
            this.timer = new Timer("Overview map redrawer");
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    PureMapGLPanel.this.display();
                }
            }, 30L, 30L);
        }
    }

    public synchronized void stopDisplayLoop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void addAgentRenderer(IPlayer agent) {
        this.agentRenderes.addRenderer(new PlayerRenderer(agent, this.lastGLName++));
    }

    private void removeAgentRenderer(IPlayer agent) {
        this.agentRenderes.removeRenderersOf(agent);
    }

    private void addFlagRenderer(FlagInfo flag) {
        FlagRenderer subRenderer = new FlagRenderer(flag, this.lastGLName++);
        this.objectRenderes.addRenderer(subRenderer);
    }

    private void addWaypointRenderer(IUnrealWaypoint waypoint) {
        WaypointRenderer subRenderer = new WaypointRenderer(waypoint, this.lastGLName++);
        this.objectRenderes.addRenderer(subRenderer);
    }

    public void preAddEvent(Collection<IPlayer> toBeAdded, Collection<IPlayer> whereToAdd) {
    }

    public synchronized void postAddEvent(Collection<IPlayer> alreadyAdded, Collection<IPlayer> whereWereAdded) {
        for (IPlayer agent : alreadyAdded) {
            this.addAgentRenderer(agent);
        }
    }

    public synchronized void preRemoveEvent(Collection<IPlayer> toBeRemoved, Collection<IPlayer> whereToRemove) {
        for (IPlayer removedAgent : toBeRemoved) {
            this.removeAgentRenderer(removedAgent);
        }
    }

    public void postRemoveEvent(Collection<IPlayer> alreadyAdded, Collection<IPlayer> whereWereRemoved) {
    }

    @Override
    public synchronized void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.server.getAgents().removeCollectionListener((CollectionEventListener)this);
        this.server.getNativeAgents().removeCollectionListener((CollectionEventListener)this);
        this.server = null;
        super.destroy();
    }
}

