/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.map;

import cz.cuni.amis.pogamut.unreal.communication.messages.gbinfomessages.IPlayer;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMap;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLJPanel;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.CollectionRenderer;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.EnvironmentRenderer;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.MapController;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.MapRenderer;
import nl.tudelft.goal.ut2004.visualizer.timeline.map.MapViewpoint;

public abstract class MapGLPanel
extends GLJPanel
implements MapViewpoint.ViewpointListener {
    protected MapViewpoint mapViewpoint;
    protected MapController mapController;
    protected MapRenderer mapRenderer;
    protected CollectionRenderer<IPlayer> agentRenderes;
    protected CollectionRenderer<Object> objectRenderes;
    protected EnvironmentRenderer environmentRenderer;
    protected int lastGLName = 1;
    private IUnrealMap map;

    protected MapGLPanel(GLCapabilities caps, IUnrealMap map) {
        super((GLCapabilitiesImmutable)caps);
        this.map = map;
        this.mapViewpoint = new MapViewpoint();
        this.mapController = new MapController(this, this.mapViewpoint, map.getBox());
        this.mapController.registerListeners();
        this.mapRenderer = new MapRenderer(map, this.lastGLName++);
        this.agentRenderes = new CollectionRenderer();
        this.objectRenderes = new CollectionRenderer();
        this.environmentRenderer = new EnvironmentRenderer(this.mapViewpoint, this.agentRenderes, this.objectRenderes, this.mapRenderer);
        this.addGLEventListener(this.environmentRenderer);
        this.mapViewpoint.addViewpointListener(this);
        this.mapViewpoint.setFromViewedBox(map.getBox());
    }

    protected MapGLPanel(IUnrealMap map, Logger log) {
        this(MapGLPanel.getCapabilities(), map);
    }

    private static GLCapabilities getCapabilities() {
        GLCapabilities caps = new GLCapabilities(GLProfile.getDefault());
        caps.setHardwareAccelerated(true);
        caps.setDoubleBuffered(true);
        return caps;
    }

    @Override
    public synchronized void onChangedViewpoint(MapViewpoint viewpoint) {
        this.display();
    }

    public synchronized Set<Object> getObjectsAt(Point p) {
        this.environmentRenderer.setSelectPoint(p);
        this.display();
        int[] list = this.environmentRenderer.getSelectedObjects();
        HashSet<Object> selection = new HashSet<Object>();
        selection.addAll(this.agentRenderes.getObjectsByGLName(list));
        selection.addAll(this.objectRenderes.getObjectsByGLName(list));
        return selection;
    }

    public synchronized void destroy() {
        this.removeGLEventListener(this.environmentRenderer);
        this.mapViewpoint.removeViewpointListener(this);
        this.mapRenderer.destroy();
        this.agentRenderes.destroy();
        this.objectRenderes.destroy();
        this.mapRenderer = null;
        this.environmentRenderer = null;
        this.agentRenderes = null;
        this.objectRenderes = null;
        this.mapController = null;
        this.mapViewpoint = null;
    }

    protected IUnrealMap getMap() {
        return this.map;
    }
}

