/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.prefs.Preferences;

public class WindowPersistenceHelper {
    private static final String WINDOW_Y = "WINDOW_Y";
    private static final String WINDOW_X = "WINDOW_X";
    private static final String WINDOW_HEIGHT = "WINDOW_HEIGHT";
    private static final String WINDOW_WIDTH = "WINDOW_WIDTH";
    private final Window window;
    private final Preferences preferences;
    private final String className;

    public WindowPersistenceHelper(Window component) {
        this.window = component;
        this.preferences = Preferences.userNodeForPackage(component.getClass());
        this.className = component.getClass().getSimpleName();
        this.window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WindowPersistenceHelper.this.save();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                WindowPersistenceHelper.this.save();
            }
        });
    }

    public void load() {
        int width = this.preferences.getInt(this.className + WINDOW_WIDTH, this.window.getWidth());
        int height = this.preferences.getInt(this.className + WINDOW_HEIGHT, this.window.getHeight());
        this.window.setSize(width, height);
        int x = this.preferences.getInt(this.className + WINDOW_X, this.window.getX());
        int y = this.preferences.getInt(this.className + WINDOW_Y, this.window.getY());
        this.window.setLocation(x, y);
    }

    public void save() {
        Dimension size = this.window.getSize();
        this.preferences.putInt(this.className + WINDOW_WIDTH, this.window.getWidth());
        this.preferences.putInt(this.className + WINDOW_HEIGHT, this.window.getHeight());
        Point position = this.window.getLocation();
        this.preferences.putInt(this.className + WINDOW_X, this.window.getX());
        this.preferences.putInt(this.className + WINDOW_Y, this.window.getY());
    }
}

