/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class SuggestionModel
implements ComboBoxModel {
    private final TreeMap<String, Object> map = new TreeMap();
    private final List<String> sortedKeys = new ArrayList<String>();
    private final List<ListDataListener> listeners = new LinkedList<ListDataListener>();
    private Object selected;

    public void addElement(Object element) {
        this.map.put(element.toString(), element);
        this.sortedKeys.add(element.toString());
        Collections.sort(this.sortedKeys);
        this.modelChanged();
    }

    private void modelChanged() {
        this.setSelectedItem(this.selected);
        this.notifyListeners();
    }

    public void removeElement(Object element) {
        this.map.remove(element.toString());
        this.sortedKeys.remove(element.toString());
        Collections.sort(this.sortedKeys);
        this.modelChanged();
    }

    private void notifyListeners() {
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(new ListDataEvent(this, 0, 0, this.getSize()));
        }
    }

    public List<String> sugestFor(String query) {
        String lowerCaseQuery = query.toLowerCase();
        LinkedList<String> suggestion = new LinkedList<String>();
        for (String key : this.map.keySet()) {
            if (!key.toLowerCase().contains(lowerCaseQuery)) continue;
            System.out.println("Found " + key);
            suggestion.add(key);
        }
        this.sortedKeys.clear();
        this.sortedKeys.addAll(suggestion);
        return suggestion;
    }

    @Override
    public Object getElementAt(int index) {
        return this.map.get(this.sortedKeys.get(index));
    }

    @Override
    public int getSize() {
        return this.sortedKeys.size();
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selected = anItem != null ? this.map.get(anItem.toString()) : anItem;
    }

    public Object getItem(String key) {
        return this.map.get(key);
    }
}

