/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui.widgets;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import nl.tudelft.goal.ut2004.visualizer.gui.widgets.SuggestionModel;

class SuggestionFieldEditor
implements ComboBoxEditor {
    private final JTextField textField = new JTextField();
    private final SuggestionModel model;
    private int nextSuggestionIndex = 0;
    private final JComboBox combobox;
    private String previousQuery = null;

    public SuggestionFieldEditor(JComboBox combobox, SuggestionModel model) {
        this.model = model;
        this.combobox = combobox;
        this.textField.addKeyListener(new Listener());
    }

    private boolean isAutoCompletionRequest(KeyEvent e) {
        return e.isControlDown() && e.getKeyChar() == ' ';
    }

    private void updateSuggestion(boolean complete) {
        this.combobox.hidePopup();
        String query = this.getUnselectedText();
        List<String> suggestions = this.model.sugestFor(query);
        if (suggestions.size() > 0 && (this.isQueryEdited(query) || complete)) {
            this.nextSuggestionIndex %= suggestions.size();
            String suggestion = suggestions.get(this.nextSuggestionIndex++);
            this.updateCompletion(complete, query, suggestion);
        } else {
            this.nextSuggestionIndex = 0;
        }
        this.combobox.showPopup();
    }

    private boolean isQueryEdited(String query) {
        boolean edited = this.previousQuery != null && query.length() > this.previousQuery.length() && query.startsWith(this.previousQuery);
        this.previousQuery = query;
        return edited;
    }

    private void updateCompletion(boolean showSuggestion, String query, String suggestion) {
        if (showSuggestion || suggestion.startsWith(query) && query.length() > 0) {
            this.textField.setText(suggestion);
            if (suggestion.startsWith(query)) {
                this.textField.select(query.length(), suggestion.length());
            } else {
                this.textField.select(suggestion.indexOf(query) + query.length(), suggestion.length());
            }
        }
    }

    private String getUnselectedText() {
        String selected = this.textField.getSelectedText();
        String fullText = this.textField.getText();
        if (selected != null && fullText.endsWith(selected)) {
            return fullText.substring(0, fullText.indexOf(selected));
        }
        return fullText;
    }

    @Override
    public Component getEditorComponent() {
        return this.textField;
    }

    @Override
    public Object getItem() {
        return this.model.getItem(this.textField.getText());
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.textField.removeActionListener(l);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.textField.addActionListener(l);
    }

    @Override
    public void selectAll() {
        this.textField.selectAll();
    }

    @Override
    public void setItem(Object item) {
        if (item != null) {
            this.textField.setText(item.toString());
        } else {
            this.textField.setText("");
        }
    }

    private class Listener
    extends KeyAdapter {
        private Listener() {
        }

        @Override
        public void keyPressed(final KeyEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SuggestionFieldEditor.this.updateSuggestion(SuggestionFieldEditor.this.isAutoCompletionRequest(e));
                }
            });
        }
    }
}

