/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui.widgets;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MapList;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.flag.FlagListener;
import java.awt.GridLayout;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import nl.tudelft.goal.ut2004.visualizer.controller.ServerController;
import nl.tudelft.goal.ut2004.visualizer.data.GameData;
import nl.tudelft.goal.ut2004.visualizer.gui.widgets.SuggestionField;
import nl.tudelft.goal.ut2004.visualizer.gui.widgets.SuggestionModel;
import nl.tudelft.goal.ut2004.visualizer.util.CollectionEventAdaptor;
import nl.tudelft.goal.ut2004.visualizer.util.SelectableMapList;

public class MapBox
extends JPanel {
    private final SuggestionField suggestionField;
    private final Listener listener;
    private final ObservableCollection<MapList> maps;
    private final SuggestionModel suggestionModel;

    public MapBox() {
        this.setLayout(new GridLayout(1, 1));
        this.listener = new Listener();
        this.suggestionModel = new SuggestionModel();
        this.suggestionField = new SuggestionField(this.suggestionModel);
        this.add(this.suggestionField);
        ServerController controller = ServerController.getInstance();
        GameData data = controller.getGameData();
        this.maps = data.getAvailableMaps();
        this.maps.addCollectionListener((CollectionEventListener)this.listener);
        this.addAll((Collection<MapList>)this.maps);
        controller.getServerDefinition().getServerFlag().addListener((FlagListener)new FlagListener<IUT2004Server>(){

            public void flagChanged(IUT2004Server changedValue) {
                if (changedValue != null) {
                    MapBox.this.suggestionField.setSelectedItem(changedValue.getMapName());
                }
            }
        });
        IUT2004Server server = controller.getServer();
        if (server != null) {
            this.suggestionField.setSelectedItem(server.getMapName());
        }
    }

    public MapList getSelected() {
        SelectableMapList sw = (SelectableMapList)this.suggestionModel.getSelectedItem();
        if (sw != null) {
            return sw.getMapList();
        }
        return null;
    }

    public void setSelected(MapList item) {
        this.suggestionField.setSelectedItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAll(Collection<MapList> maps) {
        Collection<MapList> collection = maps;
        synchronized (collection) {
            for (MapList w : maps) {
                this.suggestionModel.addElement(new SelectableMapList(w));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAll(Collection<MapList> maps) {
        Collection<MapList> collection = maps;
        synchronized (collection) {
            for (MapList w : maps) {
                this.suggestionModel.removeElement(new SelectableMapList(w));
            }
        }
    }

    public void dispose() {
        this.maps.removeCollectionListener((CollectionEventListener)this.listener);
    }

    private class Listener
    extends CollectionEventAdaptor<MapList> {
        private Listener() {
        }

        @Override
        public void postRemoveEvent(final Collection<MapList> alreadyRemoved, Collection<MapList> whereWereRemoved) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapBox.this.removeAll(alreadyRemoved);
                }
            });
        }

        @Override
        public void postAddEvent(final Collection<MapList> alreadyAdded, Collection<MapList> whereWereAdded) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapBox.this.addAll(alreadyAdded);
                }
            });
        }
    }
}

