/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.gui.action;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeMap;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MapList;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.utils.flag.FlagListener;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import nl.tudelft.goal.ut2004.visualizer.controller.ServerController;
import nl.tudelft.goal.ut2004.visualizer.gui.widgets.MapBox;

public class ChangeMapAction
extends AbstractAction {
    private final MapBox mapSelection;

    public ChangeMapAction(MapBox box) {
        this.mapSelection = box;
        this.putValue("ShortDescription", "Change the current map");
        this.putValue("Name", "Change map");
        ServerController controller = ServerController.getInstance();
        controller.getServerDefinition().getServerFlag().addListener((FlagListener)new FlagListener<IUT2004Server>(){

            public void flagChanged(IUT2004Server changedValue) {
                if (changedValue == null) {
                    ChangeMapAction.this.setEnabled(false);
                } else {
                    ChangeMapAction.this.setEnabled(true);
                }
            }
        });
        IUT2004Server server = controller.getServer();
        if (server == null) {
            this.setEnabled(false);
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        ServerController controller = ServerController.getInstance();
        IUT2004Server server = controller.getServer();
        assert (server != null);
        MapList selected = this.mapSelection.getSelected();
        if (selected != null) {
            server.getAct().act((CommandMessage)new ChangeMap().setMapName(selected.getName()));
        }
    }
}

