/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.configuration;

import cz.cuni.amis.utils.configuration.PropertyProvider;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.logging.DefaultLogFormatter;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class PropertiesManager {
    Logger log = Logger.getLogger("PropertiesManager");
    private List<PropertyProvider> providers = null;

    public PropertiesManager() {
        this.log.addHandler(new Handler(){
            DefaultLogFormatter logFormatter = new DefaultLogFormatter("Platform", false);

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }

            @Override
            public void publish(LogRecord record) {
                System.out.println(this.logFormatter.format(record));
            }
        });
        this.log.setLevel(Level.INFO);
        this.log.info("Instantiated");
    }

    protected List<PropertyProvider> getProvidersList() {
        try {
            if (this.providers == null) {
                this.providers = new LinkedList<PropertyProvider>();
                ServiceLoader<PropertyProvider> loader = ServiceLoader.load(PropertyProvider.class);
                HashSet loaded = new HashSet();
                for (PropertyProvider provider : loader) {
                    if (loaded.contains(provider.getClass())) {
                        if (!this.log.isLoggable(Level.WARNING)) continue;
                        this.log.warning("Attempt to register PropertyProvider of class " + provider.getClass() + " twice, ignoring.");
                        continue;
                    }
                    this.providers.add(provider);
                    loaded.add(provider.getClass());
                }
                Collections.sort(this.providers);
                this.logProvidersOrder();
            }
        }
        catch (Exception e) {
            throw new PogamutException("Could not initialize PropertiesManager: " + e.getMessage(), (Throwable)e, this.log, this);
        }
        return this.providers;
    }

    protected void logProvidersOrder() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Property providers order:");
        }
        if (this.getProvidersList() != null && this.getProvidersList().size() != 0) {
            for (PropertyProvider provider : this.getProvidersList()) {
                String str = "[" + provider.getPriority() + "] \t " + provider.toString();
                if (!this.log.isLoggable(Level.INFO)) continue;
                this.log.info(str);
            }
        } else if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning("There are no PropertyProvider(s) registered inside PropertiesManager! No properties will be available!");
        }
    }

    public String getProperty(String key) {
        for (PropertyProvider provider : this.getProvidersList()) {
            String val = provider.getProperty(key);
            if (val == null) continue;
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Property " + key + " was loaded from " + provider.toString() + ".");
            }
            return val;
        }
        return null;
    }
}

