/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ListConcatenation<T>
extends AbstractList<T> {
    private List<List<T>> lists;

    public static <T> List<T> concatenate(List<T> ... lists) {
        return ListConcatenation.concatenate(Arrays.asList(lists));
    }

    public static <T> List<T> concatenate(List<List<T>> lists) {
        if (lists.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<List<T>> nonEmptyBasicLists = new ArrayList<List<T>>(lists.size());
        for (List<T> list : lists) {
            if (list instanceof ListConcatenation) {
                nonEmptyBasicLists.addAll(((ListConcatenation)list).lists);
                continue;
            }
            if (list.isEmpty()) continue;
            nonEmptyBasicLists.add(list);
        }
        if (lists.size() == 1) {
            return lists.get(0);
        }
        return new ListConcatenation<T>(lists);
    }

    public ListConcatenation(List<List<T>> lists) {
        this.lists = new ArrayList<List<T>>(lists);
    }

    public ListConcatenation(List<T> ... lists) {
        this.lists = Arrays.asList(lists);
    }

    @Override
    public T get(int index) {
        int listId;
        for (listId = 0; listId < this.lists.size() && index >= this.lists.get(listId).size(); index -= this.lists.get(listId).size(), ++listId) {
        }
        if (listId > this.lists.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return this.lists.get(listId).get(index);
    }

    @Override
    public int size() {
        int totalSize = 0;
        for (List<T> list : this.lists) {
            totalSize += list.size();
        }
        return totalSize;
    }
}

