/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.utils.maps.HashMapSet;
import java.util.HashMap;
import java.util.Set;

public class UT2004ItemType
extends ItemType {
    protected static HashMap<String, ItemType> protos = new HashMap();
    public static final HashMapSet<UT2004Group, ItemType> GROUPS = new HashMapSet();
    private ItemType.Category category;
    private UT2004Group group;
    public static final UT2004ItemType TRANSLOCATOR = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.TRANSLOCATOR, new String[]{"XWeapons.TransPickup", "XWeapons.Transpickup", "XWeapons.Translauncher"});
    public static final UT2004ItemType TRANSLOCATOR_PROJECTILE = UT2004ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT2004Group.TRANSLOCATOR, new String[]{"XWeapons.BlueBeacon", "XWeapons.RedBeacon"});
    public static final UT2004ItemType SHIELD_GUN = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.SHIELD_GUN, new String[]{"XWeapons.ShieldGunPickup", "XWeapons.ShieldGun"});
    public static final UT2004ItemType SHIELD_GUN_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.SHIELD_GUN, new String[]{"XWeapons.ShieldAmmoPickup", "XWeapons.ShieldAmmo"});
    public static final UT2004ItemType ASSAULT_RIFLE = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.ASSAULT_RIFLE, new String[]{"XWeapons.AssaultRiflePickup", "XWeapons.AssaultRifle"});
    public static final UT2004ItemType ASSAULT_RIFLE_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.ASSAULT_RIFLE, new String[]{"XWeapons.AssaultAmmoPickup", "XWeapons.AssaultAmmo"});
    public static final UT2004ItemType ASSAULT_RIFLE_GRENADE = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.ASSAULT_RIFLE, new String[]{"XWeapons.GrenadeAmmoPickup", "XWeapons.GrenadeAmmo"});
    public static final UT2004ItemType ASSAULT_RIFLE_PROJECTILE = UT2004ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT2004Group.ASSAULT_RIFLE, new String[]{"XWeapons.Grenade"});
    public static final UT2004ItemType BIO_RIFLE = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.BIO_RIFLE, new String[]{"XWeapons.BioRiflePickup", "UTClassic.ClassicBioRiflePickup", "XWeapons.BioRifle"});
    public static final UT2004ItemType BIO_RIFLE_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.BIO_RIFLE, new String[]{"XWeapons.BioAmmoPickup", "XWeapons.BioAmmo"});
    public static final UT2004ItemType BIO_RIFLE_PROJECTILE = UT2004ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT2004Group.BIO_RIFLE, new String[]{"XWeapons.BioGlob"});
    public static final UT2004ItemType SHOCK_RIFLE = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.SHOCK_RIFLE, new String[]{"XWeapons.ShockRiflePickup", "UTClassic.ClassicShockRiflePickup", "XWeapons.ShockRifle"});
    public static final UT2004ItemType SHOCK_RIFLE_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.SHOCK_RIFLE, new String[]{"XWeapons.ShockAmmoPickup", "XWeapons.ShockAmmo"});
    public static final UT2004ItemType SHOCK_RIFLE_PROJECTILE = UT2004ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT2004Group.SHOCK_RIFLE, new String[]{"XWeapons.ShockProjectile"});
    public static final UT2004ItemType LINK_GUN = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.LINK_GUN, new String[]{"XWeapons.LinkGunPickup", "XWeapons.LinkGun"});
    public static final UT2004ItemType LINK_GUN_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.LINK_GUN, new String[]{"XWeapons.LinkAmmoPickup", "XWeapons.LinkAmmo"});
    public static final UT2004ItemType LINK_GUN_PROJECTILE = UT2004ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT2004Group.LINK_GUN, new String[]{"XWeapons.LinkProjectile"});
    public static final UT2004ItemType MINIGUN = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.MINIGUN, new String[]{"XWeapons.MinigunPickup", "UTClassic.ClassicMinigunPickup", "XWeapons.Minigun"});
    public static final UT2004ItemType MINIGUN_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.MINIGUN, new String[]{"XWeapons.MinigunAmmoPickup", "XWeapons.MinigunAmmo"});
    public static final UT2004ItemType FLAK_CANNON = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.FLAK_CANNON, new String[]{"XWeapons.FlakCannonPickup", "UTClassic.ClassicFlakCannonPickup", "XWeapons.FlakCannon"});
    public static final UT2004ItemType FLAK_CANNON_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.FLAK_CANNON, new String[]{"XWeapons.FlakAmmoPickup", "XWeapons.FlakAmmo"});
    public static final UT2004ItemType FLAK_CANNON_CHUNK = UT2004ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT2004Group.FLAK_CANNON, new String[]{"XWeapons.FlakChunk"});
    public static final UT2004ItemType FLAK_CANNON_SHELL = UT2004ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT2004Group.FLAK_CANNON, new String[]{"XWeapons.FlakShell"});
    public static final UT2004ItemType ROCKET_LAUNCHER = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.ROCKET_LAUNCHER, new String[]{"XWeapons.RocketLauncherPickup", "UTClassic.ClassicRocketLauncherPickup", "XWeapons.RocketLauncher"});
    public static final UT2004ItemType ROCKET_LAUNCHER_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.ROCKET_LAUNCHER, new String[]{"XWeapons.RocketAmmoPickup", "XWeapons.RocketAmmo"});
    public static final UT2004ItemType ROCKET_LAUNCHER_PROJECTILE = UT2004ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT2004Group.ROCKET_LAUNCHER, new String[]{"XWeapons.RocketProj"});
    public static final UT2004ItemType LIGHTNING_GUN = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.LIGHTNING_GUN, new String[]{"XWeapons.SniperRiflePickup", "XWeapons.SniperRifle"});
    public static final UT2004ItemType LIGHTNING_GUN_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.LIGHTNING_GUN, new String[]{"XWeapons.SniperAmmoPickup", "XWeapons.SniperAmmo"});
    public static final UT2004ItemType SNIPER_RIFLE = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.SNIPER_RIFLE, new String[]{"UTClassic.ClassicSniperRiflePickup"});
    public static final UT2004ItemType SNIPER_RIFLE_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.SNIPER_RIFLE, new String[]{"UTClassic.ClassicSniperAmmoPickup", "UTClassic.ClassicSniperAmmo"});
    public static final UT2004ItemType REDEEMER = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.REDEEMER, new String[]{"XWeapons.RedeemerPickup", "XWeapons.Redeemer"});
    public static final UT2004ItemType REDEEMER_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.REDEEMER, new String[]{"XWeapons.RedeemerAmmo"});
    public static final UT2004ItemType REDEEMER_PROJECTILE = UT2004ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT2004Group.REDEEMER, new String[]{"XWeapons.RedeemerProjectile"});
    public static final UT2004ItemType SUPER_SHOCK_RIFLE = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.SUPER_SHOCK_RIFLE, new String[]{"XWeapons.SuperShockRiflePickup", "XWeapons.SuperShockRifle"});
    public static final UT2004ItemType ION_PAINTER = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.ION_PAINTER, new String[]{"XWeapons.PainterPickup", "XWeapons.Painter"});
    public static final UT2004ItemType ION_PAINTER_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.ION_PAINTER, new String[]{"XWeapons.BallAmmo"});
    public static final UT2004ItemType ONS_MINE_LAYER = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.ONS_MINE_LAYER, new String[]{"Onslaught.ONSMineLayerPickup", "Onslaught.ONSMineLayer"});
    public static final UT2004ItemType ONS_MINE_LAYER_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.ONS_MINE_LAYER, new String[]{"Onslaught.ONSMineAmmoPickup", "Onslaught.ONSMineAmmo"});
    public static final UT2004ItemType ONS_MINE_LAYER_PROJECTILE = UT2004ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT2004Group.ONS_MINE_LAYER, new String[]{"Onslaught.ONSMineProjectileRED", "Onslaught.ONSMineProjectileBLUE"});
    public static final UT2004ItemType ONS_GRENADE_LAUNCHER = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.ONS_GRENADE_LAUNCHER, new String[]{"Onslaught.ONSGrenadePickup", "Onslaught.ONSGrenade"});
    public static final UT2004ItemType ONS_GRENADE_LAUNCHER_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.ONS_GRENADE_LAUNCHER, new String[]{"Onslaught.ONSGrenadeAmmoPickup"});
    public static final UT2004ItemType ONS_GRENADE_LAUNCHER_PROJECTILE = UT2004ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT2004Group.ONS_GRENADE_LAUNCHER, new String[]{"Onslaught.ONSGrenadeProjectile"});
    public static final UT2004ItemType ONS_AVRIL = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.ONS_AVRIL, new String[]{"Onslaught.ONSAVRiLPickup", "Onslaught.ONSAVRiL"});
    public static final UT2004ItemType ONS_AVRIL_AMMO = UT2004ItemType.MakePrototype(ItemType.Category.AMMO, UT2004Group.ONS_AVRIL, new String[]{"Onslaught.ONSAVRiLAmmoPickup"});
    public static final UT2004ItemType ONS_AVRIL_PROJECTILE = UT2004ItemType.MakePrototype(ItemType.Category.PROJECTILE, UT2004Group.ONS_AVRIL, new String[]{"Onslaught.ONSAVRiLRocket"});
    public static final UT2004ItemType ONS_TARGET_PAINTER = UT2004ItemType.MakePrototype(ItemType.Category.WEAPON, UT2004Group.ONS_TARGET_PAINTER, new String[]{"OnslaughtFull.ONSPainterPickup", "OnslaughtFull.ONSPainter"});
    public static final UT2004ItemType HEALTH_PACK = UT2004ItemType.MakePrototype(ItemType.Category.HEALTH, UT2004Group.HEALTH, new String[]{"XPickups.HealthPack", "XPickups.TournamentHealth"});
    public static final UT2004ItemType MINI_HEALTH_PACK = UT2004ItemType.MakePrototype(ItemType.Category.HEALTH, UT2004Group.MINI_HEALTH, new String[]{"XPickups.MiniHealthPack"});
    public static final UT2004ItemType SUPER_HEALTH_PACK = UT2004ItemType.MakePrototype(ItemType.Category.HEALTH, UT2004Group.SUPER_HEALTH, new String[]{"XPickups.SuperHealthPack"});
    public static final UT2004ItemType SHIELD_PACK = UT2004ItemType.MakePrototype(ItemType.Category.ARMOR, UT2004Group.SMALL_ARMOR, new String[]{"XPickups.ShieldPack", "XPickups.ShieldPickup"});
    public static final UT2004ItemType SUPER_SHIELD_PACK = UT2004ItemType.MakePrototype(ItemType.Category.ARMOR, UT2004Group.SUPER_ARMOR, new String[]{"XPickups.SuperShieldPack"});
    public static final UT2004ItemType U_DAMAGE_PACK = UT2004ItemType.MakePrototype(ItemType.Category.OTHER, UT2004Group.UDAMAGE, new String[]{"XPickups.UDamagePack", "XGame.UDamageReward"});
    public static final UT2004ItemType ADRENALINE_PACK = UT2004ItemType.MakePrototype(ItemType.Category.ADRENALINE, UT2004Group.ADRENALINE, new String[]{"XPickups.AdrenalinePickup"});
    public static final UT2004ItemType KEY = UT2004ItemType.MakePrototype(ItemType.Category.OTHER, UT2004Group.KEY, new String[]{"UnrealGame.KeyPickup"});
    public static final UT2004ItemType NONE = UT2004ItemType.MakePrototype(ItemType.Category.OTHER, UT2004Group.NONE, new String[]{"None", "NONE", "none"});
    protected String name;

    @Override
    public String toString() {
        return "ItemType[name = " + this.name + ", category = " + (Object)((Object)this.category) + ", group = " + this.group + "]";
    }

    @Override
    public ItemType.Category getCategory() {
        return this.category;
    }

    @Override
    public UT2004Group getGroup() {
        return this.group;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof UT2004ItemType && this.category == ((UT2004ItemType)obj).getCategory() && this.group == ((UT2004ItemType)obj).getGroup() && this.name == ((UT2004ItemType)obj).getName();
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public int compareTo(ItemType o) {
        if (o == null) {
            return 1;
        }
        if (this.getName() == null) {
            if (o.getName() == null) {
                return 0;
            }
            return 1;
        }
        if (o.getName() == null) {
            return -1;
        }
        return this.getName().compareTo(o.getName());
    }

    public UT2004ItemType(String name) {
        this.name = name;
        this.category = ItemType.Category.OTHER;
        this.group = UT2004Group.OTHER;
    }

    private UT2004ItemType(String name, ItemType.Category category, UT2004Group group) {
        this.name = name;
        this.category = category;
        this.group = group;
    }

    public static ItemType getWeapon(UnrealId id) {
        if (id == null) {
            return null;
        }
        String str = id.getStringId();
        if (str.contains(".")) {
            str = str.substring(str.lastIndexOf(".") + 1);
        }
        if ((str = str.toLowerCase()).equals("assaultrifle")) {
            return ASSAULT_RIFLE;
        }
        if (str.equals("shieldgun")) {
            return SHIELD_GUN;
        }
        if (str.equals("flakcannon")) {
            return FLAK_CANNON;
        }
        if (str.equals("biorifle")) {
            return BIO_RIFLE;
        }
        if (str.equals("shockrifle")) {
            return SHOCK_RIFLE;
        }
        if (str.equals("linkgun")) {
            return LINK_GUN;
        }
        if (str.equals("sniperrifle")) {
            return SNIPER_RIFLE;
        }
        if (str.equals("rocketlauncher")) {
            return ROCKET_LAUNCHER;
        }
        if (str.equals("minigun")) {
            return MINIGUN;
        }
        if (str.equals("lightinggun")) {
            return LIGHTNING_GUN;
        }
        if (str.equals("translocator")) {
            return TRANSLOCATOR;
        }
        if (str.equals("translauncher")) {
            return TRANSLOCATOR;
        }
        if (str.equals("redeemer")) {
            return REDEEMER;
        }
        if (str.equals("painter")) {
            return ION_PAINTER;
        }
        if (str.equals("classicsniperrifle")) {
            return SNIPER_RIFLE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UT2004ItemType MakePrototype(ItemType.Category category, UT2004Group group, String[] utNames) {
        UT2004ItemType type;
        HashMap<String, ItemType> hashMap = protos;
        synchronized (hashMap) {
            type = new UT2004ItemType(utNames[0], category, group);
            for (String utName : utNames) {
                protos.put(utName, type);
            }
            if (category != null) {
                CATEGORIES.get((Object)category).add(type);
            }
            if (group != null) {
                GROUPS.get(group).add(type);
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemType getItemType(String utName) {
        ItemType type;
        HashMap<String, ItemType> hashMap = protos;
        synchronized (hashMap) {
            type = protos.get(utName);
            if (type != null) {
                return type;
            }
            type = new UT2004ItemType(utName);
            protos.put(utName, type);
        }
        return type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static enum UT2004Group implements ItemType.Group
    {
        TRANSLOCATOR("Translocator"),
        SHIELD_GUN("ShieldGun"),
        ASSAULT_RIFLE("AssaultRifle"),
        BIO_RIFLE("BioRifle"),
        SHOCK_RIFLE("ShockRifle"),
        LINK_GUN("LinkGun"),
        MINIGUN("Minigun"),
        FLAK_CANNON("FlakCannon"),
        ROCKET_LAUNCHER("RocketLauncher"),
        LIGHTNING_GUN("LightningGun"),
        SNIPER_RIFLE("SniperRifle"),
        ION_PAINTER("IonPainter"),
        REDEEMER("Redeemer"),
        SUPER_SHOCK_RIFLE("SuperShockRifle"),
        ONS_MINE_LAYER("ONS MineLayer"),
        ONS_GRENADE_LAUNCHER("ONS GrenadeLauncher"),
        ONS_AVRIL("ONS AVRiL"),
        ONS_TARGET_PAINTER("TargetPainter"),
        HEALTH("HealthKit"),
        MINI_HEALTH("HealthVial"),
        SUPER_HEALTH("SuperHealth"),
        SMALL_ARMOR("SmallShield"),
        SUPER_ARMOR("SuperShield"),
        ADRENALINE("Adrenaline"),
        UDAMAGE("UDamage"),
        KEY("Key"),
        OTHER("Unknown"),
        NONE("None");

        public String name;

        private UT2004Group(String name) {
            this.name = name;
        }

        @Override
        public Set<ItemType> getTypes() {
            return GROUPS.get(this);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

