/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.exception.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectFuture;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.RemoveRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.utils.flag.Flag;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;

public class RaycastingUT2004
extends SensomotoricModule<UT2004Bot> {
    Map<String, WorldObjectFuture<AutoTraceRay>> rayFutures = new HashMap<String, WorldObjectFuture<AutoTraceRay>>();
    String idSuffix = null;
    int counter = 0;
    int alreadyInitialized = 0;
    Flag<Boolean> allRaysInitialized = new Flag<Boolean>(false);
    boolean listening = false;

    public Flag<Boolean> getAllRaysInitialized() {
        return this.allRaysInitialized.getImmutable();
    }

    public RaycastingUT2004(UT2004Bot bot) {
        this(bot, (Logger)null);
    }

    public RaycastingUT2004(UT2004Bot bot, Logger log) {
        super(bot, log);
        this.idSuffix = "_" + bot.getName() + UUID.randomUUID().toString();
        this.cleanUp();
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        for (Map.Entry<String, WorldObjectFuture<AutoTraceRay>> entry : this.rayFutures.entrySet()) {
            final AutoTraceRay ray = (AutoTraceRay)entry.getValue().get(0L, TimeUnit.MILLISECONDS);
            if (ray != null) {
                ((UT2004Bot)this.agent).getWorldView().notifyImmediately(new IWorldObjectUpdatedEvent(){

                    @Override
                    public WorldObjectId getId() {
                        return ray.getId();
                    }

                    @Override
                    public IWorldObjectUpdateResult<IWorldObject> update(IWorldObject obj) {
                        return new IWorldObjectUpdateResult.WorldObjectUpdateResult<IWorldObject>(IWorldObjectUpdateResult.Result.DESTROYED, obj);
                    }

                    @Override
                    public long getSimTime() {
                        return ray.getSimTime();
                    }
                });
            }
            entry.getValue().cancel(false);
        }
        this.rayFutures.clear();
        this.allRaysInitialized.setFlag(false);
        this.alreadyInitialized = 0;
        this.listening = false;
    }

    public void clear() throws CommunicationException {
        this.act.act(new RemoveRay("All"));
        this.cleanUp();
    }

    public void endRayInitSequence() {
        this.listening = true;
        this.checkIfAllInited();
    }

    public Future<AutoTraceRay> createRay(String Id2, Vector3d Direction2, int Length, boolean FastTrace2, boolean FloorCorrection, boolean TraceActors) throws CommunicationException {
        AddRay addRay = new AddRay(Id2, Direction2, Length, FastTrace2, FloorCorrection, TraceActors);
        WorldObjectFuture<AutoTraceRay> future = new WorldObjectFuture<AutoTraceRay>(this.worldView, Id2, AutoTraceRay.class){

            @Override
            protected void customObjectEncounteredHook(AutoTraceRay obj) {
                ++RaycastingUT2004.this.alreadyInitialized;
                RaycastingUT2004.this.checkIfAllInited();
            }
        };
        this.rayFutures.put(Id2, future);
        this.act.act(addRay);
        return future;
    }

    public Future<AutoTraceRay> createRay(Vector3d Direction2, int Length, boolean FastTrace2, boolean FloorCorrection, boolean TraceActors) throws CommunicationException {
        String id = this.counter++ + this.idSuffix;
        return this.createRay(id, Direction2, Length, FastTrace2, FloorCorrection, TraceActors);
    }

    public AutoTraceRay getRay(String rayID) {
        try {
            Future ray = this.rayFutures.get(rayID);
            if (ray == null) {
                return null;
            }
            if (ray.isDone()) {
                return (AutoTraceRay)ray.get();
            }
            return null;
        }
        catch (Exception ex) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(ex.getMessage());
            }
            return null;
        }
    }

    protected void checkIfAllInited() {
        if (this.listening && this.rayFutures.size() == this.alreadyInitialized) {
            this.allRaysInitialized.setFlag(true);
        }
    }
}

