/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.context;

import cz.cuni.amis.pogamut.base.agent.IGhostAgent;
import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.sposh.JavaBehaviour;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AdrenalineCombo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentStats;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.CTF;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.ItemDescriptors;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavPoints;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphBuilder;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.UT2004AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.UT2004Items;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPrefs;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.Visibility;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.astar.UT2004AStar;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.command.CompleteBotCommandsWrapper;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.Random;
import java.util.logging.Level;

public class UT2004Behaviour<BOT extends UT2004Bot>
extends JavaBehaviour<BOT> {
    protected Random random = new Random(System.currentTimeMillis());
    protected LogCategory user = null;
    protected LogCategory log = null;
    protected Game game;
    protected AgentInfo info;
    protected Players players;
    protected ItemDescriptors descriptors;
    protected Items items;
    protected Senses senses;
    protected Weaponry weaponry;
    protected AgentConfig config;
    protected Raycasting raycasting;
    protected CompleteBotCommandsWrapper body;
    protected ImprovedShooting shoot;
    protected AdvancedLocomotion move;
    protected UT2004PathExecutor<ILocated> pathExecutor = null;
    protected IPathPlanner<ILocated> pathPlanner = null;
    protected WeaponPrefs weaponPrefs;
    protected NavigationGraphBuilder navBuilder;
    protected AgentStats stats;
    protected FloydWarshallMap fwMap;
    protected UT2004GetBackToNavGraph getBackToNavGraph;
    protected UT2004RunStraight runStraight;
    protected UT2004Navigation navigation;
    protected Visibility visibility;
    protected AnnotationListenerRegistrator listenerRegistrator;
    protected IVisionWorldView world;
    protected NavPoints navPoints;
    protected UT2004AStar aStar;
    protected CTF ctf;
    protected AdrenalineCombo combo;
    protected IAct act;

    public UT2004Behaviour(String name, BOT bot) {
        super(name, bot);
        this.log = ((AbstractAgent)bot).getLogger().getCategory("User");
        this.log.setLevel(Level.ALL);
        this.user = this.log;
    }

    protected void initializeBehaviour(BOT bot) {
        this.initializeModules(bot);
        this.initializePathFinding(bot);
        this.initializeListeners(bot);
    }

    protected void initializeListeners(BOT bot) {
        this.listenerRegistrator = new AnnotationListenerRegistrator(this, this.getWorldView(), ((AbstractAgent)bot).getLogger().getCategory("Listeners"));
        this.listenerRegistrator.addListeners();
    }

    protected void initializePathFinding(BOT bot) {
        this.pathPlanner = new UT2004AStarPathPlanner((UT2004Bot)bot);
        this.fwMap = new FloydWarshallMap((IGhostAgent)bot);
        this.aStar = new UT2004AStar((UT2004Bot)bot);
        this.pathExecutor = new UT2004PathExecutor((UT2004Bot)bot, this.info, this.move, new LoqueNavigator((UT2004Bot)bot, this.info, this.move, ((AbstractAgent)bot).getLog()));
        this.getBackToNavGraph = new UT2004GetBackToNavGraph((UT2004Bot)bot, this.info, this.move);
        this.runStraight = new UT2004RunStraight((UT2004Bot)bot, this.info, this.move);
        this.navigation = new UT2004Navigation((UT2004Bot)bot, this.pathExecutor, this.fwMap, this.getBackToNavGraph, this.runStraight);
    }

    protected void initializeModules(BOT bot) {
        this.world = this.getWorldView();
        this.act = this.getAct();
        this.game = new Game((UT2004Bot)bot);
        this.navPoints = new NavPoints((UT2004Bot)bot);
        this.players = new Players((UT2004Bot)bot);
        this.descriptors = new ItemDescriptors((UT2004Bot)bot);
        this.config = new AgentConfig((UT2004Bot)bot);
        this.raycasting = new Raycasting((UT2004Bot)bot);
        this.stats = new AgentStats((IObservingAgent)bot);
        this.navBuilder = new NavigationGraphBuilder((UT2004Bot)bot);
        this.info = new UT2004AgentInfo((UT2004Bot)bot, this.game);
        this.visibility = new Visibility((UT2004Bot)bot, this.info);
        this.ctf = new CTF((UT2004Bot)bot, this.info);
        this.weaponry = new Weaponry((UT2004Bot)bot, this.descriptors);
        this.items = new UT2004Items((UT2004Bot)bot, this.info, this.game, this.weaponry, null);
        this.senses = new Senses((UT2004Bot)bot, this.info, this.players);
        this.body = new CompleteBotCommandsWrapper((UT2004Bot)bot, this.weaponry, null);
        this.shoot = this.body.getImprovedShooting();
        this.move = this.body.getLocomotion();
        this.weaponPrefs = new WeaponPrefs(this.weaponry, (UT2004Bot)bot);
        this.combo = new AdrenalineCombo((UT2004Bot)bot, this.info);
    }

    protected void prepareBehaviour(BOT bot) {
    }

    public void botInitialized(GameInfo info, ConfigChange config, InitedMessage init) {
    }

    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
    }

    public void finishBehaviourInitialization() {
        if (this.navBuilder.isUsed()) {
            this.log.info("Navigation graph has been altered by 'navBuilder', triggering recomputation of Floyd-Warshall path matrix...");
            Level oldLevel = this.fwMap.getLog().getLevel();
            this.fwMap.getLog().setLevel(Level.FINER);
            this.fwMap.refreshPathMatrix();
            this.fwMap.getLog().setLevel(oldLevel);
        }
    }

    public void botKilled(BotKilled event) {
    }

    public IVisionWorldView getWorldView() {
        return ((UT2004Bot)this.bot).getWorldView();
    }

    public IAct getAct() {
        return ((UT2004Bot)this.bot).getAct();
    }

    public UT2004GetBackToNavGraph getGetBackToNavGraph() {
        return this.getBackToNavGraph;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Random getRandom() {
        return this.random;
    }

    public LogCategory getLog() {
        return this.log;
    }

    public Game getGame() {
        return this.game;
    }

    public AgentInfo getInfo() {
        return this.info;
    }

    public Players getPlayers() {
        return this.players;
    }

    public ItemDescriptors getDescriptors() {
        return this.descriptors;
    }

    public Items getItems() {
        return this.items;
    }

    public Senses getSensesModule() {
        return this.senses;
    }

    public Weaponry getWeaponry() {
        return this.weaponry;
    }

    public AgentConfig getConfig() {
        return this.config;
    }

    public Raycasting getRaycasting() {
        return this.raycasting;
    }

    public CompleteBotCommandsWrapper getBody() {
        return this.body;
    }

    public ImprovedShooting getShoot() {
        return this.shoot;
    }

    public AdvancedLocomotion getMove() {
        return this.move;
    }

    public UT2004PathExecutor<ILocated> getPathExecutor() {
        return this.pathExecutor;
    }

    public IPathPlanner<ILocated> getPathPlanner() {
        return this.pathPlanner;
    }

    public WeaponPrefs getWeaponPrefs() {
        return this.weaponPrefs;
    }

    public NavigationGraphBuilder getNavBuilder() {
        return this.navBuilder;
    }

    public AgentStats getStats() {
        return this.stats;
    }

    public FloydWarshallMap getFwMap() {
        return this.fwMap;
    }

    public UT2004RunStraight getRunStraight() {
        return this.runStraight;
    }

    public UT2004Navigation getNavigation() {
        return this.navigation;
    }

    public IVisionWorldView getWorld() {
        return this.world;
    }

    public NavPoints getNavPoints() {
        return this.navPoints;
    }

    public UT2004AStar getaStar() {
        return this.aStar;
    }

    public CTF getCtf() {
        return this.ctf;
    }

    public AdrenalineCombo getCombo() {
        return this.combo;
    }
}

