/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Emoticon;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonBubbleType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonInfo;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.NewEmoticonEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetEmoticon;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.HashMap;

public class Emoticons
extends SensomotoricModule<UT2004Bot> {
    private Self self = null;
    private static double DEFAULT_DURATION = 5.0;
    private static EmoticonBubbleType DEFAULT_BUBBLE = EmoticonBubbleType.BUBBLE_THOUGHT_CENTER;
    HashMap<UnrealId, EmoticonInfo> playersEmoticons = new HashMap();
    IWorldObjectListener<Self> storeSelfListener = new IWorldObjectListener<Self>(){

        @Override
        public void notify(IWorldObjectEvent<Self> event) {
            if (Emoticons.this.self == null) {
                Emoticons.this.self = event.getObject();
                Emoticons.this.worldView.removeObjectListener(Self.class, this);
                Emoticons.this.storeSelfListener = null;
            }
        }
    };
    IWorldObjectEventListener<Player, WorldObjectUpdatedEvent<Player>> playersListener = new IWorldObjectEventListener<Player, WorldObjectUpdatedEvent<Player>>(){

        @Override
        public void notify(WorldObjectUpdatedEvent<Player> event) {
            Player upPl = (Player)event.getObject();
            Emoticon actualEmot = Emoticons.this.getPlayerEmoticon(upPl);
            if (Emoticons.this.playersEmoticons.containsKey(upPl.getId())) {
                Emoticon previousEmot = Emoticons.this.playersEmoticons.get(upPl.getId()).getEmoticon();
                if (!previousEmot.equals(actualEmot)) {
                    Emoticons.this.playersEmoticons.put(upPl.getId(), new EmoticonInfo(actualEmot, event.getSimTime()));
                    Emoticons.this.worldView.notify(new NewEmoticonEvent(upPl.getId(), actualEmot, event.getSimTime()));
                }
            } else {
                Emoticons.this.playersEmoticons.put(upPl.getId(), new EmoticonInfo(actualEmot, event.getSimTime()));
                Emoticons.this.worldView.notify(new NewEmoticonEvent(upPl.getId(), actualEmot, event.getSimTime()));
            }
        }
    };

    public EmoticonType[] getCurrentEmoticonTypes() {
        return this.getCurrentEmoticon().getEmoticonTypes();
    }

    public Emoticon getCurrentEmoticon() {
        if (this.self == null) {
            return new Emoticon(EmoticonType.NONE, EmoticonBubbleType.NONE);
        }
        return new Emoticon(EmoticonType.get(this.self.getEmotLeft()), EmoticonType.get(this.self.getEmotCenter()), EmoticonType.get(this.self.getEmotRight()), EmoticonBubbleType.get(this.self.getBubble()));
    }

    public Emoticon getPlayerEmoticon(Player player) {
        return new Emoticon(EmoticonType.get(player.getEmotLeft()), EmoticonType.get(player.getEmotCenter()), EmoticonType.get(player.getEmotRight()), EmoticonBubbleType.get(player.getBubble()));
    }

    public EmoticonInfo getPlayerEmoticonInfo(UnrealId playerId) {
        if (this.playersEmoticons.containsKey(playerId)) {
            return this.playersEmoticons.get(playerId);
        }
        return new EmoticonInfo(new Emoticon(EmoticonType.NONE, EmoticonType.NONE, EmoticonType.NONE, EmoticonBubbleType.NONE), 0L);
    }

    public void setEmoticon(Emoticon emoticon) {
        if (emoticon.getEmoticonCount() == 3) {
            this.setTripleEmoticon(emoticon.getLeftEmoticon(), emoticon.getCenterEmoticon(), emoticon.getRightEmoticon(), DEFAULT_DURATION, emoticon.getBubble());
        } else if (emoticon.getEmoticonCount() == 2) {
            this.setDoubleEmoticon(emoticon.getLeftEmoticon(), emoticon.getRightEmoticon(), DEFAULT_DURATION, emoticon.getBubble());
        } else {
            this.setCenterEmoticonType(emoticon.getCenterEmoticon(), DEFAULT_DURATION, emoticon.getBubble());
        }
    }

    public void setEmoticon(Emoticon emoticon, double duration) {
        if (emoticon.getEmoticonCount() == 3) {
            this.setTripleEmoticon(emoticon.getLeftEmoticon(), emoticon.getCenterEmoticon(), emoticon.getRightEmoticon(), duration, emoticon.getBubble());
        } else if (emoticon.getEmoticonCount() == 2) {
            this.setDoubleEmoticon(emoticon.getLeftEmoticon(), emoticon.getRightEmoticon(), duration, emoticon.getBubble());
        } else {
            this.setCenterEmoticonType(emoticon.getCenterEmoticon(), duration, emoticon.getBubble());
        }
    }

    public EmoticonType getCurrentLeftEmoticonType() {
        if (this.self == null) {
            return EmoticonType.NONE;
        }
        return EmoticonType.NONE;
    }

    public EmoticonType getCurrentCenterEmoticonType() {
        if (this.self == null) {
            return EmoticonType.NONE;
        }
        if (EmoticonType.has(this.self.getEmotCenter())) {
            return EmoticonType.get(this.self.getEmotCenter());
        }
        return EmoticonType.NONE;
    }

    public EmoticonType getCurrentRightEmoticonType() {
        if (this.self == null) {
            return EmoticonType.NONE;
        }
        if (EmoticonType.has(this.self.getEmotRight())) {
            return EmoticonType.get(this.self.getEmotRight());
        }
        return EmoticonType.NONE;
    }

    public EmoticonBubbleType getCurrentBubbleType() {
        if (this.self == null) {
            return EmoticonBubbleType.NONE;
        }
        if (EmoticonBubbleType.has(this.self.getBubble())) {
            return EmoticonBubbleType.get(this.self.getBubble());
        }
        return EmoticonBubbleType.NONE;
    }

    public void setEmoticons(double duration, EmoticonBubbleType bubble, EmoticonType ... emoticons) {
        this.clearEmoticons();
        if (emoticons == null || emoticons.length == 0) {
            return;
        }
        switch (emoticons.length) {
            case 1: {
                this.setCenterEmoticonType(emoticons[0], duration, bubble);
                return;
            }
            case 2: {
                this.setDoubleEmoticon(emoticons[0], emoticons[1], duration, bubble);
                return;
            }
            case 3: {
                this.setTripleEmoticon(emoticons[0], emoticons[1], emoticons[3], duration, bubble);
                return;
            }
        }
        this.log.warning("Unsupported number of emoticons to show (" + emoticons.length + "), cannot show more than 3, discarding the rest.");
        this.setTripleEmoticon(emoticons[0], emoticons[1], emoticons[3], duration, bubble);
    }

    public void clearEmoticons() {
        this.setTripleEmoticon(EmoticonType.NONE, EmoticonType.NONE, EmoticonType.NONE, 0.0, EmoticonBubbleType.NONE);
    }

    @Deprecated
    public void setCenterEmoticonType(EmoticonType type) {
        this.setCenterEmoticonType(type, DEFAULT_DURATION, DEFAULT_BUBBLE);
    }

    @Deprecated
    public void setCenterEmoticonType(EmoticonType type, double duration) {
        this.setCenterEmoticonType(type, duration, DEFAULT_BUBBLE);
    }

    @Deprecated
    public void setCenterEmoticonType(EmoticonType centerEmoticon, double duration, EmoticonBubbleType bubble) {
        this.act.act(new SetEmoticon(centerEmoticon.id, 1, null, 0, null, 0, bubble.id, 1, duration));
    }

    @Deprecated
    public void setDoubleEmoticon(EmoticonType left, EmoticonType right) {
        this.setDoubleEmoticon(left, right, DEFAULT_DURATION);
    }

    @Deprecated
    public void setDoubleEmoticon(EmoticonType left, EmoticonType right, double duration) {
        this.setDoubleEmoticon(left, right, duration, DEFAULT_BUBBLE);
    }

    @Deprecated
    public void setDoubleEmoticon(EmoticonType left, EmoticonType right, double duration, EmoticonBubbleType bubble) {
        this.act.act(new SetEmoticon(null, 0, left.id, 1, right.id, 1, bubble.id, 1, duration));
    }

    @Deprecated
    public void setTripleEmoticon(EmoticonType left, EmoticonType center, EmoticonType right) {
        this.setTripleEmoticon(left, center, right, DEFAULT_DURATION);
    }

    @Deprecated
    public void setTripleEmoticon(EmoticonType left, EmoticonType center, EmoticonType right, double duration) {
        this.setTripleEmoticon(left, center, right, duration, DEFAULT_BUBBLE);
    }

    @Deprecated
    public void setTripleEmoticon(EmoticonType left, EmoticonType center, EmoticonType right, double duration, EmoticonBubbleType bubble) {
        this.act.act(new SetEmoticon(center.id, 1, left.id, 1, right.id, 1, bubble.id, 1, duration));
    }

    public Emoticons(UT2004Bot agent) {
        super(agent);
        agent.getWorldView().addObjectListener(Self.class, this.storeSelfListener);
        agent.getWorldView().addObjectListener(Player.class, WorldObjectUpdatedEvent.class, this.playersListener);
    }
}

