/*
 * Decompiled with CFR 0.152.
 */
package SteeringProperties;

import SteeringStuff.SteeringType;
import java.io.Serializable;

public abstract class SteeringProperties
implements Serializable {
    protected SteeringType type;
    protected boolean active;
    protected double weight;
    protected BehaviorType behaviorType;

    public SteeringProperties(SteeringType type) {
        this.type = type;
        this.active = false;
        this.weight = 1.0;
        this.behaviorType = BehaviorType.OWN;
    }

    public SteeringProperties(SteeringType type, BehaviorType behaviorType) {
        this.type = type;
        this.active = false;
        this.weight = 1.0;
        this.behaviorType = behaviorType;
    }

    public SteeringProperties(SteeringType type, boolean active, double weight) {
        this.type = type;
        this.active = active;
        this.weight = weight;
        this.behaviorType = BehaviorType.OWN;
    }

    public SteeringProperties(SteeringType type, boolean active, double weight, BehaviorType behaviorType) {
        this.type = type;
        this.active = active;
        this.weight = weight;
        this.behaviorType = behaviorType;
    }

    public SteeringType getType() {
        return this.type;
    }

    public void setType(SteeringType type) {
        this.type = type;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public BehaviorType getBehaviorType() {
        return this.behaviorType;
    }

    public void setBehaviorType(BehaviorType behaviorType) {
        if (this.behaviorType != behaviorType && behaviorType != BehaviorType.OWN) {
            this.setNewBehaviorType(behaviorType);
        }
        this.behaviorType = behaviorType;
    }

    public String getText() {
        String text = "* " + this.type.getName() + "\n";
        text = text + "  * Weight: " + this.weight + "\n";
        text = text + this.getSpecialText();
        return text;
    }

    protected abstract void setNewBehaviorType(BehaviorType var1);

    public abstract void setProperties(SteeringProperties var1);

    public abstract String getSpecialText();

    public static enum BehaviorType {
        BASIC,
        ADVANCED,
        OWN;

    }
}

