/*
 * Decompiled with CFR 0.152.
 */
package SteeringProperties;

import SteeringProperties.ForcePoint;
import XMLSteeringProperties.XMLForcePoint;
import XMLSteeringProperties.XMLForce_packet;
import java.util.ArrayList;
import java.util.LinkedList;

public class Force_packet {
    private LinkedList<ForcePoint> forcePoints;
    private int LAST_DISTANCE = 4000;

    public Force_packet(LinkedList<ForcePoint> forcePoints) {
        this.forcePoints = forcePoints;
    }

    public Force_packet(int forceValue) {
        this.forcePoints = new LinkedList();
        this.forcePoints.add(new ForcePoint(0, forceValue, true));
    }

    public Force_packet(int firstForceValue, int lastForceValue) {
        this.forcePoints = new LinkedList();
        this.forcePoints.add(new ForcePoint(0, firstForceValue, true));
        this.forcePoints.add(new ForcePoint(this.LAST_DISTANCE, lastForceValue, true));
    }

    public Force_packet(XMLForce_packet xmlPacket) {
        this.forcePoints = new LinkedList();
        for (XMLForcePoint x : xmlPacket.forces) {
            this.forcePoints.add(new ForcePoint(x));
        }
    }

    public Force_packet(Force_packet force_packet) {
        this.forcePoints = new LinkedList();
        this.setForcePacket(force_packet);
    }

    public void setForcePacket(Force_packet f_packet) {
        this.forcePoints.clear();
        for (ForcePoint fPoint : f_packet.forcePoints) {
            this.forcePoints.add(new ForcePoint(fPoint));
        }
        this.LAST_DISTANCE = f_packet.LAST_DISTANCE;
    }

    public LinkedList<ForcePoint> getForcePoints() {
        return this.forcePoints;
    }

    public int getLAST_DISTANCE() {
        return this.LAST_DISTANCE;
    }

    public void addForcePoint(ForcePoint forcePoint) {
        int index = 0;
        for (ForcePoint fp : this.forcePoints) {
            if (fp.distance >= forcePoint.distance) continue;
            ++index;
        }
        this.forcePoints.add(index, forcePoint);
    }

    public void deleteForcePoint(ForcePoint forcePoint) {
        if (this.forcePoints.getFirst() != forcePoint) {
            this.forcePoints.remove(forcePoint);
        }
    }

    public int getValueOfTheDistance(double distance) {
        int value = 0;
        ForcePoint lowerFP = this.getLowerFP(distance);
        ForcePoint higherFP = this.getHigherFP(distance);
        if (lowerFP != null && lowerFP.continues) {
            if (higherFP == null) {
                higherFP = this.getInifinityPoint();
            }
            float direction = higherFP.distance != lowerFP.distance ? (float)(higherFP.forceValue - lowerFP.forceValue) / (float)(higherFP.distance - lowerFP.distance) : 0.0f;
            value = this.getValueOfTheLine(lowerFP.distance, lowerFP.forceValue, distance, direction);
        }
        return value;
    }

    public String getSpecialText() {
        String result = "";
        for (ForcePoint fp : this.forcePoints) {
            result = result + fp.getSpecialText();
        }
        return result;
    }

    public XMLForce_packet getXMLForce_packet() {
        XMLForce_packet xmlPacket = new XMLForce_packet();
        ArrayList<XMLForcePoint> xmlForces = new ArrayList<XMLForcePoint>();
        for (ForcePoint fp : this.forcePoints) {
            xmlForces.add(fp.getXMLForcePoint());
        }
        xmlPacket.forces = xmlForces;
        return xmlPacket;
    }

    public ForcePoint getLowerFP(double distance) {
        ForcePoint result = null;
        for (ForcePoint fp : this.forcePoints) {
            if (!((double)fp.distance <= distance)) continue;
            result = fp;
        }
        return result;
    }

    public ForcePoint getHigherFP(double distance) {
        ForcePoint result = null;
        for (int index = this.forcePoints.size() - 1; index >= 0; --index) {
            ForcePoint fp = this.forcePoints.get(index);
            if (!((double)fp.distance >= distance)) continue;
            result = fp;
        }
        return result;
    }

    public int getValueOfTheLine(int fromDistance, int fromValue, double toDistance, float direction) {
        return Math.round((float)fromValue + (float)(toDistance - (double)fromDistance) * direction);
    }

    public ForcePoint getInifinityPoint() {
        ForcePoint fp1 = null;
        ForcePoint fp2 = null;
        int size = this.forcePoints.size();
        if (size > 1) {
            fp1 = this.forcePoints.get(size - 2);
        }
        if (size > 0) {
            fp2 = this.forcePoints.get(size - 1);
        }
        return this.getInifinityPoint(fp1, fp2);
    }

    public ForcePoint getInifinityPoint(ForcePoint fp1, ForcePoint fp2) {
        ForcePoint result = null;
        if (fp1 != null) {
            int infinityDistance = this.LAST_DISTANCE;
            int valueOfInfinityDistance = this.getValueOfTheLine(fp2.distance, fp2.forceValue, infinityDistance, (float)(fp2.forceValue - fp1.forceValue) / (float)(fp2.distance - fp1.distance));
            result = new ForcePoint(infinityDistance, valueOfInfinityDistance, false);
        } else {
            int infinityDistance = this.LAST_DISTANCE;
            int valueOfInfinityDistance = fp2.forceValue;
            result = new ForcePoint(infinityDistance, valueOfInfinityDistance, false);
        }
        return result;
    }
}

