/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.emohawk.translators;

import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonType;
import eis.iilang.Identifier;
import eis.iilang.Parameter;
import java.util.Arrays;
import nl.tudelft.goal.EIS2Java.exception.TranslationException;
import nl.tudelft.goal.EIS2Java.translation.Java2Parameter;
import nl.tudelft.goal.EIS2Java.translation.Parameter2Java;
import nl.tudelft.goal.EIS2Java.translation.Translator;

public class EmoticonTypeTranslator
implements Java2Parameter<EmoticonType>,
Parameter2Java<EmoticonType> {
    @Override
    public EmoticonType translate(Parameter parameter) throws TranslationException {
        String emoticonTypeString = Translator.getInstance().translate2Java(parameter, String.class);
        emoticonTypeString = emoticonTypeString.toUpperCase();
        try {
            return EmoticonType.valueOf(emoticonTypeString);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("%s was not a emoticon. Expected one of %s.", emoticonTypeString, this.getValidValues());
            throw new TranslationException(message, e);
        }
    }

    public String getValidValues() {
        EmoticonType[] types2 = EmoticonType.values();
        Object[] values = new String[types2.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = types2[i].name().toLowerCase();
        }
        return Arrays.toString(values);
    }

    @Override
    public Class<EmoticonType> translatesTo() {
        return EmoticonType.class;
    }

    @Override
    public Parameter[] translate(EmoticonType argument) throws TranslationException {
        return new Parameter[]{new Identifier(argument.name().toLowerCase())};
    }

    @Override
    public Class<? extends EmoticonType> translatesFrom() {
        return EmoticonType.class;
    }
}

