/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.emohawk.agent;

import SteeringProperties.ObstacleAvoidanceProperties;
import SteeringProperties.WalkAlongProperties;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Place;
import cz.cuni.amis.pogamut.emohawk.bot.impl.EmohawkBotController;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.exception.PogamutException;
import eis.exceptions.ActException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import nl.tudelft.goal.EIS2Java.annotation.AsAction;
import nl.tudelft.goal.EIS2Java.annotation.AsPercept;
import nl.tudelft.goal.EIS2Java.handlers.AsynchronousEntity;
import nl.tudelft.goal.EIS2Java.translation.Filter;
import nl.tudelft.goal.emohawk.translators.UnrealIdOrLocation;
import nl.tudelft.goal.unreal.messages.BotParameters;

public class EmohawkBotBehavior
extends EmohawkBotController<UT2004Bot>
implements AsynchronousEntity {
    private Semaphore logic = new Semaphore(0, true);
    private WalkAlongProperties walkAlongProperties;
    private BotParameters parameters;

    @Override
    public void initializeController(UT2004Bot bot) {
        super.initializeController(bot);
        IAgentLogger logger = bot.getLogger();
        UT2004BotParameters parameters = bot.getParams();
        if (parameters instanceof BotParameters) {
            this.parameters = (BotParameters)parameters;
        } else {
            this.log.warning("Provided parameters were not a subclass of UnrealGoalParameters, using defaults.");
            this.parameters = new BotParameters(logger);
        }
        BotParameters defaults = BotParameters.getDefaults(logger);
        this.parameters.assignDefaults(defaults);
    }

    @Override
    protected void initializeModules(UT2004Bot bot) {
        super.initializeModules(bot);
        this.steering.addObstacleAvoidanceSteering(new ObstacleAvoidanceProperties());
        this.walkAlongProperties = new WalkAlongProperties();
        this.walkAlongProperties.setDistanceFromThePartner(200);
        this.walkAlongProperties.setGiveWayToPartner(false);
        this.steering.addWalkAlongSteering(new WalkAlongProperties());
    }

    @Override
    public Initialize getInitializeCommand() {
        assert (this.parameters != null);
        Initialize init = super.getInitializeCommand();
        init.setDesiredSkill(this.parameters.getSkill());
        init.setSkin(this.parameters.getSkin().getUnrealName());
        init.setTeam(this.parameters.getTeam());
        init.setShouldLeadTarget(this.parameters.shouldLeadTarget());
        init.setLocation(this.parameters.getStartLocation());
        init.setRotation(this.parameters.getStartRotation());
        this.bot.getLogger().setLevel(this.parameters.getLogLevel());
        return init;
    }

    @Override
    public void logic() throws PogamutException {
        super.logic();
        this.log.fine("--- Logic iteration ---");
        this.logic.release();
        try {
            this.logic.acquire();
        }
        catch (InterruptedException e) {
            throw new PogamutException("Logic was interupted while aquiring a permit.", e);
        }
    }

    @Override
    public void botShutdown() {
        super.botShutdown();
        this.logic.release();
    }

    @Override
    public void acquire() throws InterruptedException {
        if (!this.logic.tryAcquire(10L, TimeUnit.SECONDS)) {
            throw new InterruptedException("Could not aquire a permit within the timeout.");
        }
    }

    @Override
    public void release() {
        this.logic.release();
    }

    @AsPercept(name="navigation")
    public String navigation() {
        if (this.steering.isNavigating()) {
            return "following";
        }
        if (this.pathExecutor.isExecuting() || this.getBackToNavGraph.isExecuting() || this.runStraight.isExecuting()) {
            return "traveling";
        }
        if (this.pathExecutor.isStuck()) {
            return "stuck";
        }
        if (this.pathExecutor.isPathUnavailable()) {
            return "path_unavailable";
        }
        if (this.pathExecutor.isTargetReached()) {
            return "destination_reached";
        }
        return "waiting";
    }

    @AsPercept(name="navPoint", multiplePercepts=true, filter=Filter.Type.ONCE)
    public Collection<NavPoint> perceptNavPoints() {
        return this.getWorld().getAll(NavPoint.class).values();
    }

    @AsPercept(name="person", multiplePercepts=true)
    public Collection<Player> person() {
        return this.getPlayers().getVisiblePlayers().values();
    }

    @AsPercept(name="self")
    public AgentInfo self() {
        return this.getInfo();
    }

    @AsPercept(name="emoticon", multiplePercepts=true, filter=Filter.Type.ONCE)
    public Collection<EmoticonType> emoticon() {
        return Arrays.asList(EmoticonType.values());
    }

    @AsPercept(name="place", multiplePercepts=true, filter=Filter.Type.ONCE)
    public Collection<Place> place() {
        return this.places.getPlaces();
    }

    @AsAction(name="stop")
    public void stop() {
        this.steering.stopNavigation();
        this.navigation.stopNavigation();
    }

    @AsAction(name="runTo")
    public void runTo(UnrealIdOrLocation destination) {
        ILocated location = this.getLocation(destination);
        this.steering.stopNavigation();
        if (!this.move.isRunning()) {
            this.move.setRun();
        }
        this.navigation.navigate(location);
    }

    @AsAction(name="walkTo")
    public void walkTo(UnrealIdOrLocation destination) {
        ILocated location = this.getLocation(destination);
        this.steering.stopNavigation();
        if (this.move.isRunning()) {
            this.move.setWalk();
        }
        this.navigation.navigate(location);
    }

    private ILocated getLocation(UnrealIdOrLocation destination) {
        ILocated location = destination.isLocation() ? destination.getLocation() : (ILocated)((Object)this.world.get(destination.getId()));
        return location;
    }

    @AsAction(name="walkAlong")
    public void walkAlong(Player partner) throws ActException {
        this.navigation.stopNavigation();
        if (!this.move.isRunning()) {
            this.move.setRun();
        }
        this.walkAlongProperties.setPartnerName(partner.getName());
        this.steering.setWalkAlongSteering(this.walkAlongProperties);
        this.steering.startNavigation();
    }

    @AsAction(name="emote")
    public void emote(EmoticonType left, EmoticonType center, EmoticonType right) throws ActException {
        this.emoticons.clearEmoticons();
        if (left == EmoticonType.NONE && center == EmoticonType.NONE && right == EmoticonType.NONE) {
            return;
        }
        if (left == EmoticonType.NONE && center != EmoticonType.NONE && right == EmoticonType.NONE) {
            this.emoticons.setCenterEmoticonType(center);
            return;
        }
        if (left != EmoticonType.NONE && center == EmoticonType.NONE && right != EmoticonType.NONE) {
            this.emoticons.setDoubleEmoticon(left, right);
            return;
        }
        this.emoticons.setTripleEmoticon(left, center, right);
    }

    @AsAction(name="turn")
    public void turn(int amount) throws ActException {
        this.move.turnHorizontal(amount);
    }

    @AsAction(name="turnTo")
    public void turnTo(ILocated location) throws ActException {
        this.move.turnTo(location);
    }

    @AsAction(name="jump")
    public void jump() throws ActException {
        this.move.jump();
    }

    @AsAction(name="skip")
    public void skip() throws ActException {
    }
}

