/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.EIS2Java.handlers;

import eis.exceptions.EntityException;
import eis.exceptions.PerceiveException;
import eis.iilang.Percept;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import nl.tudelft.goal.EIS2Java.annotation.AsPercept;
import nl.tudelft.goal.EIS2Java.handlers.AbstractPerceptHandler;
import nl.tudelft.goal.EIS2Java.handlers.AsynchronousEntity;
import nl.tudelft.goal.EIS2Java.translation.Filter;
import nl.tudelft.goal.EIS2Java.util.EIS2JavaUtil;

public final class SynchronizedPerceptHandler
extends AbstractPerceptHandler {
    protected final Collection<Method> perceptMethods;
    protected final AsynchronousEntity entity;

    public SynchronizedPerceptHandler(AsynchronousEntity entity) throws EntityException {
        super(entity);
        this.entity = entity;
        this.perceptMethods = EIS2JavaUtil.processPerceptAnnotations(entity.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LinkedList<Percept> getAllPercepts() throws PerceiveException {
        LinkedList<Percept> percepts = new LinkedList<Percept>();
        try {
            this.entity.acquire();
            try {
                for (Method method : this.perceptMethods) {
                    percepts.addAll(this.getPercepts(method));
                }
            }
            finally {
                this.entity.release();
            }
        }
        catch (InterruptedException e) {
            throw new PerceiveException("Unable to perceive any percepts. Could not aquire entity.", (Exception)e);
        }
        return percepts;
    }

    private List<Percept> getPercepts(Method method) throws PerceiveException {
        ArrayList<Object> perceptObjects = new ArrayList();
        AsPercept annotation = method.getAnnotation(AsPercept.class);
        Filter.Type filter = annotation.filter();
        if (filter != Filter.Type.ONCE || this.previousPercepts.get(method) == null) {
            perceptObjects = this.getPerceptObjects(method);
        }
        List<Percept> percepts = this.translatePercepts(method, perceptObjects);
        return percepts;
    }

    private List<Object> getPerceptObjects(Method method) throws PerceiveException {
        Object returnValue;
        AsPercept annotation = method.getAnnotation(AsPercept.class);
        String perceptName = annotation.name();
        try {
            returnValue = method.invoke((Object)this.entity, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new PerceiveException("Unable to perceive " + perceptName, (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new PerceiveException("Unable to perceive " + perceptName, (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new PerceiveException("Unable to perceive " + perceptName, (Exception)e);
        }
        return this.unpackPerceptObject(method, returnValue);
    }
}

