/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.EIS2Java.handlers;

import eis.exceptions.PerceiveException;
import eis.iilang.Function;
import eis.iilang.Parameter;
import eis.iilang.Percept;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nl.tudelft.goal.EIS2Java.annotation.AsPercept;
import nl.tudelft.goal.EIS2Java.exception.TranslationException;
import nl.tudelft.goal.EIS2Java.handlers.PerceptHandler;
import nl.tudelft.goal.EIS2Java.translation.Filter;
import nl.tudelft.goal.EIS2Java.translation.Translator;

public abstract class AbstractPerceptHandler
extends PerceptHandler {
    protected final Object entity;
    protected Map<Method, List<Object>> previousPercepts = new HashMap<Method, List<Object>>();

    public AbstractPerceptHandler(Object entity) {
        assert (entity != null);
        this.entity = entity;
    }

    protected final List<Percept> translatePercepts(Method method, List<Object> perceptObjects) throws PerceiveException {
        Parameter[] parameters;
        List<Object> addList = new ArrayList<Object>();
        ArrayList<Object> delList = new ArrayList<Object>();
        AsPercept annotation = method.getAnnotation(AsPercept.class);
        Filter.Type filter = annotation.filter();
        String perceptName = annotation.name();
        List<Object> previous = this.previousPercepts.get(method);
        if (filter == Filter.Type.ONCE && previous != null) {
            return new ArrayList<Percept>();
        }
        if (previous == null) {
            previous = new LinkedList<Object>();
            this.previousPercepts.put(method, previous);
        }
        switch (filter) {
            case ALWAYS: 
            case ONCE: {
                addList = perceptObjects;
                break;
            }
            case ON_CHANGE: {
                if (((Object)perceptObjects).equals(previous)) break;
                addList = perceptObjects;
                break;
            }
            case ON_CHANGE_NEG: {
                addList.addAll(perceptObjects);
                if (previous == null) break;
                addList.removeAll(previous);
                delList.addAll(previous);
                delList.removeAll(perceptObjects);
            }
        }
        ArrayList<Percept> percepts = new ArrayList<Percept>();
        for (Object javaObject : addList) {
            try {
                parameters = Translator.getInstance().translate2Parameter(javaObject);
            }
            catch (TranslationException e) {
                throw new PerceiveException("Unable to translate percept " + perceptName, (Exception)e);
            }
            percepts.add(new Percept(perceptName, parameters));
        }
        for (Object javaObject : delList) {
            try {
                parameters = Translator.getInstance().translate2Parameter(javaObject);
            }
            catch (TranslationException e) {
                throw new PerceiveException("Unable to translate percept " + perceptName, (Exception)e);
            }
            percepts.add(new Percept("not", new Parameter[]{new Function(perceptName, parameters)}));
        }
        this.previousPercepts.put(method, perceptObjects);
        return percepts;
    }

    protected final List<Object> unpackPerceptObject(Method method, Object perceptObject) throws PerceiveException {
        AsPercept annotation = method.getAnnotation(AsPercept.class);
        String perceptName = annotation.name();
        ArrayList<Object> generatedJavaObjects = new ArrayList<Object>();
        if (!annotation.multiplePercepts()) {
            generatedJavaObjects = new ArrayList(1);
            if (perceptObject != null) {
                generatedJavaObjects.add(perceptObject);
            }
        } else {
            if (!(perceptObject instanceof Collection)) {
                throw new PerceiveException("Unable to perceive " + perceptName + " because a collection was expected but a " + perceptObject.getClass() + " was returned instead");
            }
            Collection javaCollection = (Collection)perceptObject;
            generatedJavaObjects = new ArrayList(javaCollection.size());
            for (Object o : javaCollection) {
                generatedJavaObjects.add(o);
            }
        }
        return generatedJavaObjects;
    }
}

