/*
 * Decompiled with CFR 0.152.
 */
package SteeringProperties;

import SteeringProperties.SteeringProperties;
import SteeringStuff.SteeringType;
import XMLSteeringProperties.XMLObstacleAvoidanceProperties;

public class ObstacleAvoidanceProperties
extends SteeringProperties {
    private int repulsiveForce;
    private int forceOrder;
    private boolean frontCollisions;
    private boolean treeCollisions;

    public ObstacleAvoidanceProperties() {
        super(SteeringType.OBSTACLE_AVOIDANCE);
        this.repulsiveForce = 240;
        this.forceOrder = 1;
        this.frontCollisions = true;
        this.treeCollisions = true;
    }

    public ObstacleAvoidanceProperties(SteeringProperties.BehaviorType behaviorType) {
        super(SteeringType.OBSTACLE_AVOIDANCE, behaviorType);
        this.repulsiveForce = 240;
        this.forceOrder = 1;
        this.frontCollisions = true;
        this.treeCollisions = true;
        this.setNewBehaviorType(behaviorType);
    }

    public ObstacleAvoidanceProperties(XMLObstacleAvoidanceProperties xml) {
        super(SteeringType.OBSTACLE_AVOIDANCE, xml.active, xml.weight, xml.behavior);
        this.repulsiveForce = xml.repulsiveForce;
        this.forceOrder = xml.forceOrder;
        this.frontCollisions = xml.frontCollisions;
        this.treeCollisions = xml.treeCollisions;
    }

    public ObstacleAvoidanceProperties(int repulsiveForce, int orderOfTheForce, boolean frontCollisions, boolean treeCollisions) {
        super(SteeringType.OBSTACLE_AVOIDANCE);
        this.repulsiveForce = repulsiveForce;
        this.forceOrder = orderOfTheForce;
        this.frontCollisions = frontCollisions;
        this.treeCollisions = treeCollisions;
    }

    @Override
    protected void setNewBehaviorType(SteeringProperties.BehaviorType behaviorType) {
        if (behaviorType.equals((Object)SteeringProperties.BehaviorType.BASIC)) {
            this.frontCollisions = false;
            this.treeCollisions = false;
        } else if (behaviorType.equals((Object)SteeringProperties.BehaviorType.ADVANCED)) {
            this.frontCollisions = true;
            this.treeCollisions = true;
        }
    }

    public int getRepulsiveForce() {
        return this.repulsiveForce;
    }

    public void setRepulsiveForce(int repulsiveForce) {
        this.repulsiveForce = repulsiveForce;
    }

    public int getForceOrder() {
        return this.forceOrder;
    }

    public void setForceOrder(int orderOfTheForce) {
        this.forceOrder = orderOfTheForce;
    }

    public boolean isFrontCollisions() {
        return this.frontCollisions;
    }

    public void setFrontCollisions(boolean frontCollisions) {
        this.frontCollisions = frontCollisions;
    }

    public boolean isTreeCollisions() {
        return this.treeCollisions;
    }

    public void setTreeCollisions(boolean treeCollisions) {
        this.treeCollisions = treeCollisions;
    }

    @Override
    public String getSpecialText() {
        String text = "";
        text = text + "  * Repulsive Force: " + this.repulsiveForce + "\n";
        text = text + "  * Force Order: " + this.forceOrder + "\n";
        text = text + "  * Front Collisions: " + this.frontCollisions + "\n";
        text = text + "  * Tree Collisions: " + this.treeCollisions + "\n";
        return text;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.repulsiveForce = ((ObstacleAvoidanceProperties)newProperties).getRepulsiveForce();
        this.forceOrder = ((ObstacleAvoidanceProperties)newProperties).getForceOrder();
        this.frontCollisions = ((ObstacleAvoidanceProperties)newProperties).isFrontCollisions();
        this.treeCollisions = ((ObstacleAvoidanceProperties)newProperties).isTreeCollisions();
    }

    public XMLObstacleAvoidanceProperties getXMLProperties() {
        XMLObstacleAvoidanceProperties xmlProp = new XMLObstacleAvoidanceProperties();
        xmlProp.repulsiveForce = this.repulsiveForce;
        xmlProp.frontCollisions = this.frontCollisions;
        xmlProp.forceOrder = this.forceOrder;
        xmlProp.treeCollisions = this.treeCollisions;
        xmlProp.active = this.active;
        xmlProp.weight = this.weight;
        xmlProp.behavior = this.behaviorType;
        return xmlProp;
    }
}

