/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.EIS2Java.handlers;

import eis.exceptions.EntityException;
import eis.exceptions.PerceiveException;
import eis.iilang.Percept;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nl.tudelft.goal.EIS2Java.handlers.AbstractPerceptHandler;
import nl.tudelft.goal.EIS2Java.util.EIS2JavaUtil;

public final class AllPerceptPerceptHandler
extends AbstractPerceptHandler {
    private Method allPerceptsMethod = null;
    private Map<String, Method> perceptMethods = new HashMap<String, Method>();

    public AllPerceptPerceptHandler(Object entity) throws EntityException {
        super(entity);
        Class<?> clazz = entity.getClass();
        this.perceptMethods = EIS2JavaUtil.processPerceptAnnotations(clazz);
        this.allPerceptsMethod = EIS2JavaUtil.processAllPerceptAnnotation(clazz);
        if (this.allPerceptsMethod == null) {
            throw new EntityException("Expected an entity with the AsAllPercepts annotation");
        }
    }

    @Override
    public final LinkedList<Percept> getAllPercepts() throws PerceiveException {
        return this.getBatchPercepts();
    }

    private LinkedList<Percept> getBatchPercepts() throws PerceiveException {
        Map batchPerceptObjects;
        LinkedList<Percept> percepts = new LinkedList<Percept>();
        try {
            Object result = this.allPerceptsMethod.invoke(this.entity, new Object[0]);
            batchPerceptObjects = (Map)result;
        }
        catch (IllegalArgumentException e) {
            throw new PerceiveException("Unable to perceive batch percept.", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new PerceiveException("Unable to perceive batch percept.", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new PerceiveException("Unable to perceive batch percept.", (Exception)e);
        }
        for (Map.Entry entry : batchPerceptObjects.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw new PerceiveException("Unable to perceive batch percept, expected a Map<String,Object>");
            }
            String perceptName = (String)entry.getKey();
            Object perceptObject = entry.getValue();
            Method method = this.perceptMethods.get(perceptName);
            if (method == null) {
                throw new PerceiveException("Unable to perceive " + perceptName + ", no matching method found by handler.");
            }
            List<Object> perceptObjects = this.unpackPerceptObject(method, perceptObject);
            List<Percept> translatedPercepts = this.translatePercepts(method, perceptObjects);
            percepts.addAll(translatedPercepts);
        }
        return percepts;
    }
}

