/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.ut2004;

import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.PoshEngine;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.engine.timer.SystemClockTimer;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.ILogicWorkExecutor;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotLogicController;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentScoped
public abstract class SposhLogicController<BOT extends UT2004Bot, WORK_EXECUTOR extends IWorkExecutor>
extends UT2004BotLogicController<BOT> {
    public static final String SPOSH_LOG_CATEGORY = "SPOSH";
    private PoshEngine engine;
    private WORK_EXECUTOR workExecutor;
    private ITimer timer;

    @Override
    public void initializeController(BOT bot) {
        PoshPlan plan;
        super.initializeController(bot);
        try {
            plan = this.parsePlan(this.getPlan());
        }
        catch (Exception ex) {
            Logger.getLogger(SposhLogicController.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        this.engine = this.createEngine(plan);
    }

    protected abstract WORK_EXECUTOR createWorkExecutor();

    protected final WORK_EXECUTOR getWorkExecutor() {
        if (this.workExecutor == null) {
            this.workExecutor = this.createWorkExecutor();
        }
        return this.workExecutor;
    }

    @Override
    public final void logic() {
        this.logicBeforePlan();
        if (this.getEngine().getLog() != null) {
            this.getEngine().getLog().info("Invoking SPOSH engine.");
        }
        LoggableWorkExecutor loggableWorkExecutor = new LoggableWorkExecutor((IWorkExecutor)this.getWorkExecutor());
        while (true) {
            PoshEngine.EvaluationResultInfo result = this.getEngine().evaluatePlan(loggableWorkExecutor);
            String lastPrimitive = loggableWorkExecutor.getLastExecutedPrimitive();
            if (result.type == null || result.type != FireResult.Type.CONTINUE && result.type != FireResult.Type.FOLLOW && result.type != FireResult.Type.FULFILLED && result.type != FireResult.Type.SURFACE_CONTINUE && result.type != FireResult.Type.FAILED) break;
            if (this.getEngine().getLog() == null) continue;
            this.getEngine().getLog().info("Plan evaluation continues...");
        }
        if (this.getEngine().getLog() != null) {
            this.getEngine().getLog().info("Plan evaluation end.");
        }
        this.logicAfterPlan();
    }

    protected void logicBeforePlan() {
        if (this.workExecutor instanceof ILogicWorkExecutor) {
            ILogicWorkExecutor logicExecutor = (ILogicWorkExecutor)this.workExecutor;
            logicExecutor.logicBeforePlan();
        }
    }

    protected void logicAfterPlan() {
        if (this.workExecutor instanceof ILogicWorkExecutor) {
            ILogicWorkExecutor logicExecutor = (ILogicWorkExecutor)this.workExecutor;
            logicExecutor.logicAfterPlan();
        }
    }

    protected ITimer createTimer() {
        return new SystemClockTimer();
    }

    protected final ITimer getTimer() {
        if (this.timer == null) {
            this.timer = this.createTimer();
        }
        return this.timer;
    }

    private PoshPlan parsePlan(String planSource) throws ParseException {
        StringReader planReader = new StringReader(planSource);
        PoshParser parser2 = new PoshParser(planReader);
        return parser2.parsePlan();
    }

    private PoshEngine createEngine(PoshPlan plan) {
        return new PoshEngine(plan, this.getTimer(), this.bot.getLogger().getCategory(SPOSH_LOG_CATEGORY));
    }

    protected final PoshEngine getEngine() {
        return this.engine;
    }

    protected abstract String getPlan() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getPlanFromStream(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuilder plan = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                plan.append(line);
            }
        }
        finally {
            br.close();
        }
        return plan.toString();
    }

    protected final String getPlanFromFile(String filename) throws IOException {
        FileInputStream f = new FileInputStream(filename);
        return this.getPlanFromStream(f);
    }

    protected final String getPlanFromResource(String resourcePath) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        return this.getPlanFromStream(cl.getResourceAsStream(resourcePath));
    }

    private static class LoggableWorkExecutor
    implements IWorkExecutor {
        public static final int DEFAULT_HISTORY_SIZE = 100;
        private final IWorkExecutor workExecutor;
        private final List<String> history;
        private final List<String> historyUm;
        private final int historySize;

        public LoggableWorkExecutor(IWorkExecutor workExecutor) {
            this(workExecutor, 100);
        }

        public LoggableWorkExecutor(IWorkExecutor workExecutor, int historySize) {
            this.workExecutor = workExecutor;
            this.history = new LinkedList<String>();
            this.historyUm = Collections.unmodifiableList(this.history);
            this.historySize = historySize;
        }

        public List<String> getHistory() {
            return this.historyUm;
        }

        public String getLastExecutedPrimitive() {
            return this.historyUm.get(0);
        }

        @Override
        public ActionResult executeAction(String actionName, VariableContext ctx) {
            this.history.add(0, actionName);
            while (this.history.size() > this.historySize) {
                this.history.remove(this.historySize);
            }
            return this.workExecutor.executeAction(actionName, ctx);
        }

        @Override
        public Object executeSense(String senseName, VariableContext ctx) {
            this.history.add(0, senseName);
            while (this.history.size() > this.historySize) {
                this.history.remove(this.historySize);
            }
            return this.workExecutor.executeSense(senseName, ctx);
        }
    }
}

