/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.NamedLapElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import java.util.List;

public class TriggeredAction
extends NamedLapElement {
    private PrimitiveCall actionCall;
    public static final DataFlavor dataFlavor = new DataFlavor(TriggeredAction.class, "triggered_action");
    public static final String taName = "taName";
    public static final String taArgs = "taAruments";

    TriggeredAction(String actionName) {
        this.actionCall = new PrimitiveCall(actionName);
    }

    TriggeredAction(PrimitiveCall actionCall) {
        this.actionCall = actionCall;
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.actionCall.toString();
    }

    @Override
    public String getName() {
        return this.actionCall.getName();
    }

    public PrimitiveCall getActionCall() {
        return this.actionCall;
    }

    public void setActionName(String newName) throws InvalidNameException, CycleException {
        if (!(newName = newName.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            throw InvalidNameException.create(newName);
        }
        String oldName = this.getName();
        this.actionCall = new PrimitiveCall(newName, this.actionCall.getParameters());
        if (this.getRootNode() != null && this.getRootNode().isCycled()) {
            this.actionCall = new PrimitiveCall(oldName, this.actionCall.getParameters());
            throw CycleException.createFromName(newName);
        }
        this.firePropertyChange(taName, oldName, newName);
    }

    @Override
    public boolean moveChild(int newIndex, PoshElement child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    public void synchronize(TriggeredAction source) throws CycleException {
        try {
            this.setActionName(source.getName());
            assert (source.getActionCall().getParameters().isEmpty());
            assert (this.actionCall.getParameters().isEmpty());
        }
        catch (InvalidNameException ex) {
            throw new FubarException("Name of the source action \"" + source.getName() + "\" is not valid for this action.", ex);
        }
    }

    private FormalParameters getParentParameters() {
        Object parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof DriveElement) {
            return new FormalParameters();
        }
        if (parent instanceof CompetenceElement) {
            CompetenceElement cel = (CompetenceElement)parent;
            Competence competence = (Competence)cel.getParent();
            return competence.getParameters();
        }
        if (parent instanceof ActionPattern) {
            ActionPattern ap = (ActionPattern)parent;
            return ap.getParameters();
        }
        throw new IllegalStateException("Unexpected parent type " + parent.getClass().getCanonicalName());
    }

    public void setArguments(Arguments newArguments) {
        String actionName = this.actionCall.getName();
        Arguments oldArguments = this.actionCall.getParameters();
        this.actionCall = new PrimitiveCall(actionName, newArguments);
        this.firePropertyChange(taArgs, oldArguments, newArguments);
    }

    public Arguments getArguments() {
        return this.actionCall.getParameters();
    }
}

