/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.introspection;

import cz.cuni.amis.introspection.Feature;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Property;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Folder
extends Feature {
    public Folder(String name) {
        super(name);
    }

    public abstract Folder[] getFolders() throws IntrospectionException;

    public abstract Property[] getProperties() throws IntrospectionException;

    public Property getProperty(String name) throws IntrospectionException {
        return (Property)this.getFeature(name, this.getProperties());
    }

    public Folder getFolder(String name) throws IntrospectionException {
        return (Folder)this.getFeature(name, this.getFolders());
    }

    private Feature getFeature(String name, Feature[] features) {
        for (Feature feature : features) {
            if (!feature.getName().equals(name)) continue;
            return feature;
        }
        return null;
    }

    public Properties createProperties() throws IntrospectionException {
        return this.createProperties("");
    }

    protected Properties createProperties(String prefix) throws IntrospectionException {
        Properties props = new Properties();
        String exPrefix = prefix + this.getName() + ".";
        for (Property property : this.getProperties()) {
            String valueStr;
            try {
                valueStr = String.valueOf(property.getValue());
            }
            catch (IntrospectionException ex) {
                Logger.getLogger(Folder.class.getName()).log(Level.SEVERE, null, ex);
                valueStr = "IllegalAccessException - failed to obtain the value";
            }
            props.setProperty(exPrefix + property.getName(), valueStr);
        }
        for (Feature feature : this.getFolders()) {
            Properties subprop = ((Folder)feature).createProperties(exPrefix);
            props.putAll((Map<?, ?>)subprop);
        }
        return props;
    }

    public void loadFromProperties(Properties props) throws IntrospectionException {
        this.loadFromProperties(props, "");
    }

    protected void loadFromProperties(Properties props, String prefix) throws IntrospectionException {
        Enumeration<?> keys = props.propertyNames();
        prefix = prefix + this.getName() + ".";
        while (keys.hasMoreElements()) {
            PropertyEditor editor;
            Property prop;
            String posfix;
            String key = (String)keys.nextElement();
            if (!key.startsWith(prefix) || (posfix = key.replaceFirst(prefix, "")).contains(".") || (prop = this.getProperty(posfix)) == null || (editor = PropertyEditorManager.findEditor(prop.getType())) == null) continue;
            editor.setAsText(props.getProperty(key));
            prop.setValue(editor.getValue());
        }
        for (Folder folder : this.getFolders()) {
            folder.loadFromProperties(props, prefix);
        }
    }
}

