/*
 * Decompiled with CFR 0.152.
 */
package SteeringProperties;

import SteeringProperties.SteeringProperties;
import SteeringStuff.SteeringType;
import XMLSteeringProperties.XMLWallFollowingProperties;

public class WallFollowingProperties
extends SteeringProperties {
    private int wallForce;
    private int forceOrder;
    private double attractiveForceWeight;
    private double repulsiveForceWeight;
    private double convexEdgesForceWeight;
    private double concaveEdgesForceWeight;
    private boolean justMySide;
    private boolean specialDetection;
    private boolean frontCollisions;

    public WallFollowingProperties() {
        super(SteeringType.WALL_FOLLOWING);
        this.wallForce = 100;
        this.forceOrder = 1;
        this.attractiveForceWeight = 1.0;
        this.repulsiveForceWeight = 1.0;
        this.concaveEdgesForceWeight = 1.0;
        this.convexEdgesForceWeight = 1.0;
        this.justMySide = true;
        this.specialDetection = true;
        this.frontCollisions = true;
    }

    public WallFollowingProperties(SteeringProperties.BehaviorType behaviorType) {
        super(SteeringType.WALL_FOLLOWING, behaviorType);
        this.wallForce = 100;
        this.forceOrder = 1;
        this.attractiveForceWeight = 1.0;
        this.repulsiveForceWeight = 1.0;
        this.concaveEdgesForceWeight = 1.0;
        this.convexEdgesForceWeight = 1.0;
        this.justMySide = true;
        this.specialDetection = true;
        this.frontCollisions = true;
        this.setNewBehaviorType(behaviorType);
    }

    public WallFollowingProperties(XMLWallFollowingProperties xml) {
        super(SteeringType.WALL_FOLLOWING, xml.active, xml.weight, xml.behavior);
        this.wallForce = xml.wallForce;
        this.forceOrder = xml.forceOrder;
        this.attractiveForceWeight = xml.attractiveForceWeight;
        this.repulsiveForceWeight = xml.repulsiveForceWeight;
        this.concaveEdgesForceWeight = xml.concaveEdgesForceWeight;
        this.convexEdgesForceWeight = xml.convexEdgesForceWeight;
        this.justMySide = xml.justMySide;
        this.specialDetection = xml.specialDetection;
        this.frontCollisions = xml.frontCollisions;
    }

    public WallFollowingProperties(int wallForce, int orderOfTheForce, int attractiveForceWeight, int repulsiveForceWeight, int concaveEdgesForceWeight, int convexEdgesForceWeight, boolean justMySide, boolean specialDetection, boolean frontCollisions) {
        super(SteeringType.WALL_FOLLOWING);
        this.wallForce = wallForce;
        this.forceOrder = orderOfTheForce;
        this.attractiveForceWeight = attractiveForceWeight;
        this.repulsiveForceWeight = repulsiveForceWeight;
        this.concaveEdgesForceWeight = concaveEdgesForceWeight;
        this.convexEdgesForceWeight = convexEdgesForceWeight;
        this.justMySide = justMySide;
        this.specialDetection = specialDetection;
        this.frontCollisions = frontCollisions;
    }

    @Override
    protected void setNewBehaviorType(SteeringProperties.BehaviorType behaviorType) {
        if (behaviorType.equals((Object)SteeringProperties.BehaviorType.BASIC)) {
            this.attractiveForceWeight = 1.0;
            this.repulsiveForceWeight = 1.0;
            this.concaveEdgesForceWeight = 1.0;
            this.convexEdgesForceWeight = 1.0;
            this.justMySide = false;
            this.specialDetection = false;
            this.frontCollisions = false;
        } else if (behaviorType.equals((Object)SteeringProperties.BehaviorType.ADVANCED)) {
            this.justMySide = true;
            this.specialDetection = true;
            this.frontCollisions = true;
        }
    }

    public int getWallForce() {
        return this.wallForce;
    }

    public void setWallForce(int force) {
        this.wallForce = force;
    }

    public int getOrderOfTheForce() {
        return this.forceOrder;
    }

    public void setOrderOfTheForce(int orderOfTheForce) {
        this.forceOrder = orderOfTheForce;
    }

    public double getAttractiveForceWeight() {
        return this.attractiveForceWeight;
    }

    public void setAttractiveForceWeight(double attractiveForceWeight) {
        this.attractiveForceWeight = attractiveForceWeight;
    }

    public double getConcaveEdgesForceWeight() {
        return this.concaveEdgesForceWeight;
    }

    public void setConcaveEdgesForceWeight(double concaveEdgesForceWeight) {
        this.concaveEdgesForceWeight = concaveEdgesForceWeight;
    }

    public double getConvexEdgesForceWeight() {
        return this.convexEdgesForceWeight;
    }

    public void setConvexEdgesForceWeight(double convexEdgesForceWeight) {
        this.convexEdgesForceWeight = convexEdgesForceWeight;
    }

    public double getRepulsiveForceWeight() {
        return this.repulsiveForceWeight;
    }

    public void setRepulsiveForceWeight(double repulsiveForceWeight) {
        this.repulsiveForceWeight = repulsiveForceWeight;
    }

    public boolean isFrontCollisions() {
        return this.frontCollisions;
    }

    public void setFrontCollisions(boolean frontCollisions) {
        this.frontCollisions = frontCollisions;
    }

    public boolean isJustMySide() {
        return this.justMySide;
    }

    public void setJustMySide(boolean justMySide) {
        this.justMySide = justMySide;
    }

    public boolean isSpecialDetection() {
        return this.specialDetection;
    }

    public void setSpecialDetection(boolean specialDetection) {
        this.specialDetection = specialDetection;
    }

    @Override
    public String getSpecialText() {
        String text = "";
        text = text + "  * Wall Force: " + this.wallForce + "\n";
        text = text + "  * Attractive Weight: " + this.attractiveForceWeight + "\n";
        text = text + "  * Repulsive Weight: " + this.repulsiveForceWeight + "\n";
        text = text + "  * Concave Weight: " + this.concaveEdgesForceWeight + "\n";
        text = text + "  * Convex Weight: " + this.convexEdgesForceWeight + "\n";
        text = text + "  * Just My Side: " + this.justMySide + "\n";
        text = text + "  * Special Detection: " + this.specialDetection + "\n";
        text = text + "  * Front Collisions: " + this.frontCollisions + "\n";
        return text;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.wallForce = ((WallFollowingProperties)newProperties).getWallForce();
        this.forceOrder = ((WallFollowingProperties)newProperties).getOrderOfTheForce();
        this.attractiveForceWeight = ((WallFollowingProperties)newProperties).getAttractiveForceWeight();
        this.repulsiveForceWeight = ((WallFollowingProperties)newProperties).getRepulsiveForceWeight();
        this.concaveEdgesForceWeight = ((WallFollowingProperties)newProperties).getConcaveEdgesForceWeight();
        this.convexEdgesForceWeight = ((WallFollowingProperties)newProperties).getConvexEdgesForceWeight();
        this.justMySide = ((WallFollowingProperties)newProperties).isJustMySide();
        this.specialDetection = ((WallFollowingProperties)newProperties).isSpecialDetection();
        this.frontCollisions = ((WallFollowingProperties)newProperties).isFrontCollisions();
    }

    public XMLWallFollowingProperties getXMLProperties() {
        XMLWallFollowingProperties xmlProp = new XMLWallFollowingProperties();
        xmlProp.wallForce = this.wallForce;
        xmlProp.forceOrder = this.forceOrder;
        xmlProp.attractiveForceWeight = this.attractiveForceWeight;
        xmlProp.repulsiveForceWeight = this.repulsiveForceWeight;
        xmlProp.concaveEdgesForceWeight = this.concaveEdgesForceWeight;
        xmlProp.convexEdgesForceWeight = this.convexEdgesForceWeight;
        xmlProp.justMySide = this.justMySide;
        xmlProp.specialDetection = this.specialDetection;
        xmlProp.frontCollisions = this.frontCollisions;
        xmlProp.active = this.active;
        xmlProp.weight = this.weight;
        xmlProp.behavior = this.behaviorType;
        return xmlProp;
    }
}

