package nl.tudelft.goal.EIS2Java.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import nl.tudelft.goal.EIS2Java.annotation.AsPercept;
import nl.tudelft.goal.EIS2Java.translation.Filter;
import nl.tudelft.goal.EIS2Java.util.EIS2JavaUtil;
import eis.exceptions.EntityException;
import eis.exceptions.PerceiveException;
import eis.iilang.Percept;

public final class SynchronizedPerceptHandler extends AbstractPerceptHandler {

	/** Collection of methods on the entity */
	protected final Collection<Method> perceptMethods;
	protected final AsynchronousEntity entity;

	public SynchronizedPerceptHandler(AsynchronousEntity entity) throws EntityException {
		super(entity);
		this.entity = entity;
		this.perceptMethods = EIS2JavaUtil.processPerceptAnnotations(entity.getClass()).values();
	}

	@Override
	public final LinkedList<Percept> getAllPercepts() throws PerceiveException {

		LinkedList<Percept> percepts = new LinkedList<Percept>();

		try {
			entity.acquire();
			try {
				for (Method method : perceptMethods) {

					percepts.addAll(getPercepts(method));
				}
			} finally {
				entity.release();
			}
		} catch (InterruptedException e) {
			throw new PerceiveException("Unable to perceive any percepts. Could not aquire entity.", e);
		}

		return percepts;
	}

	/**
	 * Creates new percepts by calling the given method on the entity.
	 * 
	 * @param entity
	 *            the entity to get the percept from.
	 * @param method
	 *            the method to invoke on the entity which must be annotated
	 *            with {@link AsPercept}.
	 * @return The percepts that were generated by invoking the method on the
	 *         entity.
	 * @throws PerceiveException
	 *             If the percepts couldn't be retrieved.
	 */
	private List<Percept> getPercepts(Method method) throws PerceiveException {

		// list of new objects for the percepts
		List<Object> perceptObjects = new ArrayList<Object>();

		// Optimization, don't call methods for once percepts if they have been
		// called before.
		AsPercept annotation = method.getAnnotation(AsPercept.class);
		Filter.Type filter = annotation.filter();
		if (filter != Filter.Type.ONCE || previousPercepts.get(method) == null) {
			perceptObjects = getPerceptObjects(method);
		}

		List<Percept> percepts = translatePercepts(method, perceptObjects);
		return percepts;
	}

	/**
	 * Get the percept objects for given percept name, using method. CHECK why
	 * use all these params, we can get name from the method, right?
	 * 
	 * @param method
	 * @param entity
	 * @param perceptName
	 * @return
	 * @throws PerceiveException
	 */
	private List<Object> getPerceptObjects(Method method) throws PerceiveException {

		AsPercept annotation = method.getAnnotation(AsPercept.class);
		String perceptName = annotation.name();

		Object returnValue;
		try {
			returnValue = method.invoke(entity);
		} catch (IllegalArgumentException e) {
			throw new PerceiveException("Unable to perceive " + perceptName, e);
		} catch (IllegalAccessException e) {
			throw new PerceiveException("Unable to perceive " + perceptName, e);
		} catch (InvocationTargetException e) {
			throw new PerceiveException("Unable to perceive " + perceptName, e);
		}

		return unpackPerceptObject(method, returnValue);
	}

}
