/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.muse.semlink;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import kul.cs.liir.muse.semlink.pbverbnet.ArgMap;
import kul.cs.liir.muse.semlink.pbverbnet.Predicate;
import kul.cs.liir.muse.semlink.pbverbnet.TypeMap;

public class PropBankVerbNet {
    private Map<String, List<ArgMap>> argMapsForPropBankFrameset;
    private Map<String, List<ArgMap>> argMapsForVerbNetClass = new HashMap<String, List<ArgMap>>();

    public static TypeMap loadTypeMap(InputStream stream) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TypeMap.class});
            return (TypeMap)context.createUnmarshaller().unmarshal(stream);
        }
        catch (JAXBException ex) {
            throw new IllegalArgumentException("Could not read PropBank - VerbNet typemap from the given input stream.", ex);
        }
    }

    public static TypeMap loadTypeMap() {
        return PropBankVerbNet.loadTypeMap(PropBankVerbNet.getTypeMapStream());
    }

    private static InputStream getTypeMapStream() {
        return PropBankVerbNet.class.getClassLoader().getResourceAsStream("kul/cs/liir/muse/vnpbMappings.xml");
    }

    public PropBankVerbNet() {
        this(PropBankVerbNet.getTypeMapStream());
    }

    public PropBankVerbNet(InputStream is) {
        this.argMapsForPropBankFrameset = new HashMap<String, List<ArgMap>>();
        TypeMap map = PropBankVerbNet.loadTypeMap(is);
        for (Predicate p : map.getPredicates()) {
            for (ArgMap argmap : p.getArgMaps()) {
                List<ArgMap> propBankList = this.argMapsForPropBankFrameset.get(argmap.getPropBankFrameSet());
                if (propBankList == null) {
                    propBankList = new ArrayList<ArgMap>();
                    this.argMapsForPropBankFrameset.put(argmap.getPropBankFrameSet(), propBankList);
                }
                propBankList.add(argmap);
                List<ArgMap> verbNetList = this.argMapsForVerbNetClass.get(argmap.getVerbNetClass());
                if (verbNetList == null) {
                    verbNetList = new ArrayList<ArgMap>();
                    this.argMapsForVerbNetClass.put(argmap.getVerbNetClass(), verbNetList);
                }
                verbNetList.add(argmap);
            }
        }
    }

    public List<ArgMap> getArgMapsForPropBankFrameSet(String frameSet) {
        return this.argMapsForPropBankFrameset.get(frameSet);
    }

    public List<ArgMap> getArgMapsForVerbNetClass(String verbNetClass) {
        return this.argMapsForVerbNetClass.get(verbNetClass);
    }
}

