/*
 * Decompiled with CFR 0.152.
 */
package cz.sokoban4j.tournament.run;

import cz.sokoban4j.SokobanConfig;
import cz.sokoban4j.tournament.run.SokobanLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SokobanLevels {
    public List<SokobanLevel> levels = new ArrayList<SokobanLevel>();

    public void validate() {
        for (SokobanLevel level : this.levels) {
            level.validate();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SokobanLevels fromString(String string) {
        SokobanLevels results = new SokobanLevels();
        String[] parts = string.split(";");
        if (parts.length % 2 != 0) {
            throw new RuntimeException("Level list string has invalid format; there is odd number of parts (should be even): " + parts.length);
        }
        int index = 0;
        while (index < parts.length) {
            String fileString = parts[index];
            File file = new File(fileString);
            String level = parts[index + 1];
            if (level.toLowerCase().equals("all")) {
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File childFile = fileArray[n2];
                        if (SokobanConfig.ELevelFormat.getExpectedLevelFormat((File)childFile) != null) {
                            int levelCount = SokobanLevel.getLevelCount(childFile);
                            int i = 0;
                            while (i < levelCount) {
                                results.levels.add(new SokobanLevel(childFile, i));
                                ++i;
                            }
                        }
                        ++n2;
                    }
                } else {
                    if (!file.isFile()) throw new RuntimeException("Invalid file, neither file nor directory: " + file.getAbsolutePath());
                    int levelCount = SokobanLevel.getLevelCount(new File(fileString));
                    int i = 0;
                    while (i < levelCount) {
                        results.levels.add(new SokobanLevel(file, i));
                        ++i;
                    }
                }
            } else {
                int levelNumber = Integer.parseInt(level);
                results.levels.add(new SokobanLevel(file, levelNumber));
            }
            index += 2;
        }
        return results;
    }
}

