/*
 * Decompiled with CFR 0.152.
 */
package cz.sokoban4j.tournament.run;

import cz.sokoban4j.SokobanConfig;
import cz.sokoban4j.utils.S4JLReader;
import cz.sokoban4j.utils.SokReader;
import java.io.File;

public class SokobanLevel {
    public File file;
    public int levelNumber;

    public SokobanLevel(File file, int levelNumber) {
        this.file = file;
        this.levelNumber = levelNumber;
    }

    public static int getLevelCount(File file) {
        if (file == null) {
            throw new RuntimeException("'file' is null");
        }
        if (!file.exists()) {
            throw new RuntimeException("'file' does not exist at: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new RuntimeException("'file' is not a file: " + file.getAbsolutePath());
        }
        SokobanConfig.ELevelFormat format = SokobanConfig.ELevelFormat.getExpectedLevelFormat((File)file);
        switch (format) {
            case S4JL: {
                return S4JLReader.getLevelNumber((File)file);
            }
            case SOK: {
                return SokReader.getLevelNumber((File)file);
            }
        }
        throw new RuntimeException("Unexpected file extension: " + file.getAbsolutePath());
    }

    public void validate() {
        if (SokobanConfig.ELevelFormat.getExpectedLevelFormat((File)this.file) == null) {
            throw new RuntimeException("Bad file format in " + this);
        }
        if (this.levelNumber < 0) {
            throw new RuntimeException("Bad level number in " + this);
        }
    }

    public String toString() {
        return "SokobanLevel[" + this.levelNumber + ";" + (this.file == null ? "null" : this.file.getAbsolutePath()) + "]";
    }
}

