/*
 * Decompiled with CFR 0.152.
 */
package cz.sokoban4j.tournament.run;

import cz.cuni.amis.utils.process.ProcessExecution;
import cz.cuni.amis.utils.process.ProcessExecutionConfig;
import cz.cuni.amis.utils.simple_logging.SimpleLogging;
import cz.sokoban4j.SokobanConfig;
import cz.sokoban4j.SokobanConsole;
import cz.sokoban4j.simulation.SokobanResult;
import cz.sokoban4j.tournament.run.SokobanLevel;
import cz.sokoban4j.tournament.run.SokobanLevels;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class RunSokobanLevels {
    private SokobanLevels levels;
    private String agentClass;
    private File resultFile;
    private SokobanConfig config;
    private String[] extraJavaArgs;

    public RunSokobanLevels(SokobanConfig config, String agentClass, SokobanLevels levels, File resultFile, String[] extraJavaArgs) {
        this.config = config;
        this.agentClass = agentClass;
        this.levels = levels;
        this.resultFile = resultFile;
        this.extraJavaArgs = extraJavaArgs;
    }

    public void run() {
        SimpleLogging.initLogging();
        int i = 0;
        while (i < this.levels.levels.size()) {
            String[] consoleArgs;
            ProcessExecutionConfig processConfig = new ProcessExecutionConfig();
            processConfig.setPathToProgram("java");
            ArrayList<String> args = new ArrayList<String>();
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> jvmArgs = runtimeMXBean.getInputArguments();
            for (String arg : jvmArgs) {
                if (arg.contains("agentlib") && arg.contains("suspend")) continue;
                args.add(arg);
            }
            if (this.extraJavaArgs != null && this.extraJavaArgs.length > 0) {
                String[] stringArray = this.extraJavaArgs;
                int n = this.extraJavaArgs.length;
                int n2 = 0;
                while (n2 < n) {
                    String extraArg = stringArray[n2];
                    args.add(extraArg);
                    ++n2;
                }
            }
            args.add("cz.sokoban4j.SokobanConsole");
            SokobanLevel level = this.levels.levels.get(i);
            this.config.level = level.file;
            this.config.levelFormat = null;
            this.config.levelNumber = level.levelNumber;
            String[] stringArray = consoleArgs = SokobanConsole.getArgs((SokobanConfig)this.config, (String)this.agentClass, (File)this.resultFile);
            int n = consoleArgs.length;
            int n3 = 0;
            while (n3 < n) {
                String arg = stringArray[n3];
                args.add(arg);
                ++n3;
            }
            processConfig.setArgs(args);
            processConfig.setExecutionDir(".");
            processConfig.setId("S4J");
            processConfig.setRedirectStdOut(true);
            processConfig.setRedirectStdErr(true);
            ProcessExecution execution = new ProcessExecution(processConfig, Logger.getAnonymousLogger());
            System.out.println("");
            System.out.println("===============================================");
            System.out.println("===============================================");
            System.out.println("RUNNING " + (i + 1) + " / " + this.levels.levels.size() + " FOR " + this.agentClass);
            System.out.println("===============================================");
            System.out.println("===============================================");
            execution.start();
            execution.getRunning().waitFor((Object[])new Boolean[]{false});
            if (execution.getExitValue() > 0) {
                System.out.println("========================================================");
                System.out.println("AGENT FAILED TO SOLVE THE LEVEL " + (i + 1));
                System.out.println(String.valueOf(level.file.getName()) + " / " + level.levelNumber);
                System.out.println("Exit code: " + execution.getExitValue() + " ~ " + SokobanResult.SokobanResultType.getForExitValue((int)execution.getExitValue()));
                System.out.println("========================================================");
                break;
            }
            if (execution.isFailed()) {
                System.out.println("==================");
                System.out.println("EXECUTION FAILURE!");
                System.out.println("==================");
                break;
            }
            ++i;
        }
    }
}

